/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.examples;

import de.learnlib.examples.LearningExample;
import de.learnlib.examples.dfa.ExampleAngluin;
import de.learnlib.examples.dfa.ExampleKeylock;
import de.learnlib.examples.dfa.ExamplePaulAndMary;
import de.learnlib.examples.mealy.ExampleCoffeeMachine;
import de.learnlib.examples.mealy.ExampleGrid;
import de.learnlib.examples.mealy.ExampleRandomMealy;
import de.learnlib.examples.mealy.ExampleShahbazGroz;
import de.learnlib.examples.mealy.ExampleStack;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.automatalib.words.Alphabet;
import net.automatalib.words.impl.Alphabets;

public abstract class LearningExamples {
    private static long RANDOM_SEED = 1337L;
    private static final Alphabet<Character> RANDOM_ALPHABET = Alphabets.characters((char)'a', (char)'c');
    private static final int RANDOM_SIZE = 100;
    private static final int GRID_XSIZE = 5;
    private static final int GRID_YSIZE = 5;
    private static final String[] RANDOM_MEALY_OUTPUTS = new String[]{"o1", "o2", "o3"};
    private static final int KEYLOCK_SIZE = 100;

    private LearningExamples() {
        throw new AssertionError((Object)"Constructor should not be invoked");
    }

    public static List<? extends LearningExample.DFALearningExample<?>> createDFAExamples() {
        return Arrays.asList(ExampleAngluin.createExample(), ExamplePaulAndMary.createExample(), ExampleKeylock.createExample(100, false), ExampleKeylock.createExample(100, true));
    }

    public static List<? extends LearningExample.MealyLearningExample<?, ?>> createMealyExamples() {
        return Arrays.asList(ExampleCoffeeMachine.createExample(), ExampleGrid.createExample(5, 5), ExampleShahbazGroz.createExample(), ExampleStack.createExample(), ExampleRandomMealy.createExample(new Random(RANDOM_SEED), RANDOM_ALPHABET, 100, RANDOM_MEALY_OUTPUTS));
    }
}

