/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.testsupport.it.learner;

import de.learnlib.api.algorithm.LearningAlgorithm;
import de.learnlib.api.query.DefaultQuery;
import de.learnlib.oracle.equivalence.vpda.SimulatorEQOracle;
import de.learnlib.testsupport.it.learner.LearnerVariant;
import net.automatalib.automata.vpda.OneSEVPA;
import net.automatalib.util.automata.Automata;
import net.automatalib.words.VPDAlphabet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.ITest;
import org.testng.annotations.Test;

public class VPDALearnerITCase<I>
implements ITest {
    private static final Logger LOGGER = LoggerFactory.getLogger(VPDALearnerITCase.class);
    private static final long NANOS_PER_MILLISECOND = 1000000L;
    private static final long MILLIS_PER_SECOND = 1000L;
    private final LearnerVariant<OneSEVPA<?, I>, I, Boolean> variant;
    private final OneSEVPA<?, I> reference;
    private final VPDAlphabet<I> alphabet;

    VPDALearnerITCase(LearnerVariant<OneSEVPA<?, I>, I, Boolean> variant, OneSEVPA<?, I> reference, VPDAlphabet<I> alphabet) {
        this.variant = variant;
        this.reference = reference;
        this.alphabet = alphabet;
    }

    @Test
    public void testLearning() {
        DefaultQuery ceQuery;
        SimulatorEQOracle eqOracle = new SimulatorEQOracle(this.reference, this.alphabet);
        LearningAlgorithm<OneSEVPA<?, I>, I, Boolean> learner = this.variant.getLearner();
        long start = System.nanoTime();
        learner.startLearning();
        while ((ceQuery = eqOracle.findCounterExample(learner.getHypothesisModel(), this.alphabet)) != null) {
            boolean refined = learner.refineHypothesis(ceQuery);
            Assert.assertTrue((boolean)refined, (String)("Real counterexample " + ceQuery.getInput() + " did not refine hypothesis"));
        }
        OneSEVPA hypothesis = (OneSEVPA)learner.getHypothesisModel();
        Assert.assertEquals((int)hypothesis.size(), (int)this.reference.size());
        Assert.assertTrue((boolean)Automata.testEquivalence(this.reference, (OneSEVPA)hypothesis, this.alphabet), (String)"Final hypothesis does not match reference automaton");
        long duration = (System.nanoTime() - start) / 1000000L;
        LOGGER.info("Passed learner integration test {} ... took [{}]", (Object)this.getTestName(), (Object)String.format("%d.%03ds", duration / 1000L, duration % 1000L));
    }

    public String getTestName() {
        return this.variant.getLearnerName() + "[" + this.variant.getName() + "]";
    }
}

