/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.testsupport.it.learner;

import de.learnlib.api.algorithm.PassiveLearningAlgorithm;
import de.learnlib.api.query.DefaultQuery;
import de.learnlib.examples.PassiveLearningExample;
import de.learnlib.testsupport.it.learner.PassiveLearnerVariant;
import java.util.Collection;
import net.automatalib.automata.concepts.SuffixOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.ITest;
import org.testng.annotations.Test;

public final class PassiveLearnerVariantTICase<I, D, M extends SuffixOutput<I, D>>
implements ITest {
    private static final Logger LOGGER = LoggerFactory.getLogger(PassiveLearnerVariantTICase.class);
    private static final long NANOS_PER_MILLISECOND = 1000000L;
    private static final long MILLIS_PER_SECOND = 1000L;
    private final PassiveLearnerVariant<? extends M, I, D> variant;
    private final PassiveLearningExample<I, D> example;

    PassiveLearnerVariantTICase(PassiveLearnerVariant<? extends M, I, D> variant, PassiveLearningExample<I, D> example) {
        this.variant = variant;
        this.example = example;
    }

    @Test
    public void testLearning() {
        PassiveLearningAlgorithm<? extends M, I, D> learner = this.variant.getLearner();
        Collection queries = this.example.getSamples();
        learner.addSamples(this.example.getSamples());
        long start = System.nanoTime();
        SuffixOutput model = (SuffixOutput)learner.computeModel();
        for (DefaultQuery qry : queries) {
            Assert.assertEquals((Object)model.computeSuffixOutput((Iterable)qry.getPrefix(), (Iterable)qry.getSuffix()), (Object)qry.getOutput());
        }
        long duration = (System.nanoTime() - start) / 1000000L;
        LOGGER.info("Passed learner integration test {} ... took [{}]", (Object)this.getTestName(), (Object)String.format("%d.%03ds", duration / 1000L, duration % 1000L));
    }

    public String getTestName() {
        return this.variant.getLearnerName() + "[" + this.variant.getName() + "]/" + this.example.getClass().getSimpleName();
    }
}

