/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.testsupport.it.learner;

import de.learnlib.api.algorithm.LearningAlgorithm;
import de.learnlib.testsupport.it.learner.LearnerVariant;
import de.learnlib.testsupport.it.learner.LearnerVariantList;
import de.learnlib.util.mealy.MealyUtil;
import java.util.ArrayList;
import java.util.List;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.transducers.MealyMachine;
import net.automatalib.automata.vpda.OneSEVPA;
import net.automatalib.words.Word;

class LearnerVariantListImpl<M, I, D>
implements LearnerVariantList<M, I, D> {
    private final List<LearnerVariant<M, I, D>> learnerVariants = new ArrayList<LearnerVariant<M, I, D>>();

    LearnerVariantListImpl() {
    }

    public List<LearnerVariant<M, I, D>> getLearnerVariants() {
        return this.learnerVariants;
    }

    @Override
    public void addLearnerVariant(String name, LearningAlgorithm<? extends M, I, D> learner) {
        this.addLearnerVariant(name, learner, -1);
    }

    @Override
    public void addLearnerVariant(String name, LearningAlgorithm<? extends M, I, D> learner, int maxRounds) {
        LearnerVariant<? extends M, I, D> variant = new LearnerVariant<M, I, D>(name, learner, maxRounds);
        this.learnerVariants.add(variant);
    }

    public static class MealySymLearnerVariantListImpl<I, O>
    implements LearnerVariantList.MealySymLearnerVariantList<I, O> {
        private final MealyLearnerVariantListImpl<I, O> mealyLearnerVariants = new MealyLearnerVariantListImpl();

        public MealyLearnerVariantListImpl<I, O> getMealyLearnerVariants() {
            return this.mealyLearnerVariants;
        }

        @Override
        public void addLearnerVariant(String name, LearningAlgorithm<? extends MealyMachine<?, I, ?, O>, I, O> learner) {
            this.addLearnerVariant(name, learner, -1);
        }

        @Override
        public void addLearnerVariant(String name, LearningAlgorithm<? extends MealyMachine<?, I, ?, O>, I, O> learner, int maxRounds) {
            this.mealyLearnerVariants.addLearnerVariant(name, (LearningAlgorithm)MealyUtil.wrapSymbolLearner(learner), maxRounds);
        }
    }

    public static class OneSEVPALearnerVariantListImpl<I>
    extends LearnerVariantListImpl<OneSEVPA<?, I>, I, Boolean>
    implements LearnerVariantList.OneSEVPALearnerVariantList<I> {
    }

    public static class MealyLearnerVariantListImpl<I, O>
    extends LearnerVariantListImpl<MealyMachine<?, I, ?, O>, I, Word<O>>
    implements LearnerVariantList.MealyLearnerVariantList<I, O> {
    }

    public static class DFALearnerVariantListImpl<I>
    extends LearnerVariantListImpl<DFA<?, I>, I, Boolean>
    implements LearnerVariantList.DFALearnerVariantList<I> {
    }
}

