/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.testsupport.it.learner;

import de.learnlib.api.algorithm.LearningAlgorithm;
import de.learnlib.api.oracle.EquivalenceOracle;
import de.learnlib.api.query.DefaultQuery;
import de.learnlib.examples.LearningExample;
import de.learnlib.testsupport.it.learner.LearnerVariant;
import java.util.Collection;
import net.automatalib.automata.UniversalDeterministicAutomaton;
import net.automatalib.util.automata.Automata;
import net.automatalib.words.Alphabet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.ITest;
import org.testng.annotations.Test;

final class LearnerVariantITCase<I, D, M extends UniversalDeterministicAutomaton<?, I, ?, ?, ?>>
implements ITest {
    private static final Logger LOGGER = LoggerFactory.getLogger(LearnerVariantITCase.class);
    private static final long NANOS_PER_MILLISECOND = 1000000L;
    private static final long MILLIS_PER_SECOND = 1000L;
    private final LearnerVariant<? extends M, I, D> variant;
    private final LearningExample<I, ? extends M> example;
    private final EquivalenceOracle<? super M, I, D> eqOracle;

    LearnerVariantITCase(LearnerVariant<? extends M, I, D> variant, LearningExample<I, ? extends M> example, EquivalenceOracle<? super M, I, D> eqOracle) {
        this.variant = variant;
        this.example = example;
        this.eqOracle = eqOracle;
    }

    @Test
    public void testLearning() {
        DefaultQuery ceQuery;
        LearningAlgorithm<? extends M, I, D> learner = this.variant.getLearner();
        Alphabet alphabet = this.example.getAlphabet();
        UniversalDeterministicAutomaton reference = (UniversalDeterministicAutomaton)this.example.getReferenceAutomaton();
        int maxRounds = this.variant.getMaxRounds();
        if (maxRounds < 0) {
            maxRounds = reference.size();
        }
        long start = System.nanoTime();
        learner.startLearning();
        int roundCounter = 0;
        while ((ceQuery = this.eqOracle.findCounterExample(learner.getHypothesisModel(), (Collection)alphabet)) != null) {
            if (++roundCounter > maxRounds) {
                Assert.fail((String)("Learning took too many rounds (> " + maxRounds + ")"));
            }
            boolean refined = learner.refineHypothesis(ceQuery);
            Assert.assertTrue((boolean)refined, (String)("Real counterexample " + ceQuery.getInput() + " did not refine hypothesis"));
        }
        UniversalDeterministicAutomaton hypothesis = (UniversalDeterministicAutomaton)learner.getHypothesisModel();
        Assert.assertEquals((int)hypothesis.size(), (int)reference.size());
        Assert.assertNull((Object)Automata.findSeparatingWord((UniversalDeterministicAutomaton)reference, (UniversalDeterministicAutomaton)hypothesis, (Collection)alphabet), (String)"Final hypothesis does not match reference automaton");
        long duration = (System.nanoTime() - start) / 1000000L;
        LOGGER.info("Passed learner integration test {} ... took [{}]", (Object)this.getTestName(), (Object)String.format("%d.%03ds", duration / 1000L, duration % 1000L));
    }

    public String getTestName() {
        return this.variant.getLearnerName() + "[" + this.variant.getName() + "]/" + this.example.getClass().getSimpleName();
    }
}

