/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.testsupport.it.learner;

import de.learnlib.api.oracle.EquivalenceOracle;
import de.learnlib.api.query.DefaultQuery;
import de.learnlib.examples.LearningExample;
import de.learnlib.examples.PassiveLearningExample;
import de.learnlib.testsupport.it.learner.LearnerVariant;
import de.learnlib.testsupport.it.learner.LearnerVariantITCase;
import de.learnlib.testsupport.it.learner.LearnerVariantListImpl;
import de.learnlib.testsupport.it.learner.PassiveLearnerVariant;
import de.learnlib.testsupport.it.learner.PassiveLearnerVariantListImpl;
import de.learnlib.testsupport.it.learner.PassiveLearnerVariantTICase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.automatalib.automata.UniversalAutomaton;
import net.automatalib.automata.UniversalDeterministicAutomaton;
import net.automatalib.automata.concepts.SuffixOutput;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;

public final class LearnerITUtil {
    private static final int MAX_LENGTH = 50;
    private static final int MAX_SIZE = 100;

    private LearnerITUtil() {
    }

    public static <I, D, A extends UniversalDeterministicAutomaton<?, I, ?, ?, ?>> List<LearnerVariantITCase<I, D, A>> createExampleITCases(LearningExample<I, ? extends A> example, LearnerVariantListImpl<A, I, D> variants, EquivalenceOracle<? super A, I, D> eqOracle) {
        List<LearnerVariant<A, I, D>> variantList = variants.getLearnerVariants();
        ArrayList<LearnerVariantITCase<I, D, A>> result = new ArrayList<LearnerVariantITCase<I, D, A>>(variantList.size());
        for (LearnerVariant<A, I, D> variant : variantList) {
            result.add(new LearnerVariantITCase<I, D, A>(variant, example, eqOracle));
        }
        return result;
    }

    public static <I, D, A extends SuffixOutput<I, D>> List<PassiveLearnerVariantTICase<I, D, A>> createPassiveExampleITCases(PassiveLearningExample<I, D> example, PassiveLearnerVariantListImpl<A, I, D> variants) {
        List<PassiveLearnerVariant<A, I, D>> variantList = variants.getLearnerVariants();
        ArrayList<PassiveLearnerVariantTICase<I, D, A>> result = new ArrayList<PassiveLearnerVariantTICase<I, D, A>>(variantList.size());
        for (PassiveLearnerVariant<A, I, D> variant : variantList) {
            result.add(new PassiveLearnerVariantTICase<I, D, A>(variant, example));
        }
        return result;
    }

    public static <I, D, M extends UniversalAutomaton<?, I, ?, ?, ?> & SuffixOutput<I, D>> Collection<DefaultQuery<I, D>> generateSamples(Alphabet<I> alphabet, M reference) {
        Random r = new Random(0L);
        int maxLength = Math.min(reference.size() * 2, 50);
        int size = Math.min(reference.size() * 2, 100);
        ArrayList<DefaultQuery<I, D>> result = new ArrayList<DefaultQuery<I, D>>(size);
        int alphabetSize = alphabet.size();
        for (int i = 0; i < size; ++i) {
            int len = r.nextInt(maxLength + 1);
            WordBuilder wb = new WordBuilder();
            for (int j = 0; j < len; ++j) {
                wb.add(alphabet.getSymbol(r.nextInt(alphabetSize)));
            }
            Word input = wb.toWord();
            Object output = ((SuffixOutput<I, D>)reference).computeOutput((Iterable)input);
            DefaultQuery qry = new DefaultQuery(input, output);
            result.add(qry);
        }
        return result;
    }
}

