/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.testsupport.it.learner;

import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.oracle.membership.SimulatorOracle;
import de.learnlib.testsupport.it.learner.LearnerVariant;
import de.learnlib.testsupport.it.learner.LearnerVariantList;
import de.learnlib.testsupport.it.learner.LearnerVariantListImpl;
import de.learnlib.testsupport.it.learner.VPDALearnerITCase;
import java.util.ArrayList;
import java.util.Random;
import net.automatalib.automata.vpda.DefaultOneSEVPA;
import net.automatalib.automata.vpda.OneSEVPA;
import net.automatalib.util.automata.random.RandomAutomata;
import net.automatalib.words.Alphabet;
import net.automatalib.words.VPDAlphabet;
import net.automatalib.words.impl.Alphabets;
import net.automatalib.words.impl.DefaultVPDAlphabet;
import org.testng.annotations.Factory;

public abstract class AbstractVPDALearnerIT {
    private static final Random RANDOM = new Random(42L);
    private static final int LOC_COUNT = 80;
    private static final double ACCEPTANCE_PROB = 0.3;
    private static final double RETURN_PROB = 0.3;
    private static final Alphabet<Character> CALL_ALPHABET = Alphabets.fromArray((Object[])new Character[]{Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3')});
    private static final Alphabet<Character> INTERNAL_ALPHABET = Alphabets.characters((char)'a', (char)'f');
    private static final Alphabet<Character> RETURN_ALPHABET = Alphabets.fromArray((Object[])new Character[]{Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9')});
    private static final VPDAlphabet<Character> VPD_ALPHABET = new DefaultVPDAlphabet(INTERNAL_ALPHABET, CALL_ALPHABET, RETURN_ALPHABET);

    @Factory
    public Object[] testRandomVPDA() {
        DefaultOneSEVPA target = RandomAutomata.randomOneSEVPA((Random)RANDOM, (int)80, VPD_ALPHABET, (double)0.3, (double)0.3, (boolean)true);
        return this.buildAllVariants((OneSEVPA)target, (VPDAlphabet)VPD_ALPHABET);
    }

    private <I> Object[] buildAllVariants(OneSEVPA<?, I> target, VPDAlphabet<I> alphabet) {
        SimulatorOracle mqOracle = new SimulatorOracle(target);
        LearnerVariantListImpl.OneSEVPALearnerVariantListImpl variants = new LearnerVariantListImpl.OneSEVPALearnerVariantListImpl();
        this.addLearnerVariants(alphabet, (MembershipOracle<I, Boolean>)mqOracle, variants);
        ArrayList<VPDALearnerITCase<I>> result = new ArrayList<VPDALearnerITCase<I>>();
        for (LearnerVariant v : variants.getLearnerVariants()) {
            result.add(new VPDALearnerITCase<I>(v, target, alphabet));
        }
        return result.toArray();
    }

    protected abstract <I> void addLearnerVariants(VPDAlphabet<I> var1, MembershipOracle<I, Boolean> var2, LearnerVariantList.OneSEVPALearnerVariantList<I> var3);
}

