/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.testsupport.it.learner;

import de.learnlib.api.StateLocalInputSUL;
import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.driver.util.StateLocalInputMealySimulatorSUL;
import de.learnlib.examples.LearningExample;
import de.learnlib.examples.LearningExamples;
import de.learnlib.oracle.equivalence.SimulatorEQOracle;
import de.learnlib.oracle.equivalence.mealy.StateLocalInputMealySimulatorEQOracle;
import de.learnlib.oracle.membership.SimulatorOracle;
import de.learnlib.oracle.membership.StateLocalInputSULOracle;
import de.learnlib.testsupport.it.learner.LearnerITUtil;
import de.learnlib.testsupport.it.learner.LearnerVariantITCase;
import de.learnlib.testsupport.it.learner.LearnerVariantList;
import de.learnlib.testsupport.it.learner.LearnerVariantListImpl;
import java.util.ArrayList;
import java.util.List;
import net.automatalib.automata.UniversalDeterministicAutomaton;
import net.automatalib.automata.transducers.MealyMachine;
import net.automatalib.automata.transducers.StateLocalInputMealyMachine;
import net.automatalib.automata.transducers.impl.compact.CompactMealy;
import net.automatalib.util.automata.transducers.MealyFilter;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;
import org.testng.annotations.Factory;

public abstract class AbstractMealyLearnerIT {
    @Factory
    public Object[] createExampleITCases() {
        ArrayList result = new ArrayList();
        List examples = LearningExamples.createMealyExamples();
        for (LearningExample.MealyLearningExample example : examples) {
            result.addAll(this.createAllVariantsITCase(example));
        }
        for (LearningExample.MealyLearningExample example : LearningExamples.createSLIMealyExamples()) {
            result.addAll(this.createPartialVariantsITCase((LearningExample.StateLocalInputMealyLearningExample)example));
        }
        return result.toArray();
    }

    private <I, O> List<LearnerVariantITCase<I, Word<O>, MealyMachine<?, I, ?, O>>> createAllVariantsITCase(LearningExample.MealyLearningExample<I, O> example) {
        Alphabet alphabet = example.getAlphabet();
        SimulatorOracle.MealySimulatorOracle mqOracle = new SimulatorOracle.MealySimulatorOracle((MealyMachine)example.getReferenceAutomaton());
        LearnerVariantListImpl.MealyLearnerVariantListImpl variants = new LearnerVariantListImpl.MealyLearnerVariantListImpl();
        this.addLearnerVariants((Alphabet<I>)alphabet, (MembershipOracle.MealyMembershipOracle<I, O>)mqOracle, variants);
        return LearnerITUtil.createExampleITCases(example, variants, new SimulatorEQOracle((UniversalDeterministicAutomaton)example.getReferenceAutomaton()));
    }

    private <I, O> List<LearnerVariantITCase<I, Word<O>, MealyMachine<?, I, ?, O>>> createPartialVariantsITCase(LearningExample.StateLocalInputMealyLearningExample<I, O> example) {
        StateLocalInputMealyMachine reference = (StateLocalInputMealyMachine)example.getReferenceAutomaton();
        Alphabet alphabet = example.getAlphabet();
        Object undefinedOutput = example.getUndefinedOutput();
        CompactMealy partialRef = MealyFilter.pruneTransitionsWithOutput((MealyMachine)reference, (Alphabet)alphabet, (Object[])new Object[]{undefinedOutput});
        StateLocalInputSULOracle mqOracle = new StateLocalInputSULOracle((StateLocalInputSUL)new StateLocalInputMealySimulatorSUL((StateLocalInputMealyMachine)partialRef), undefinedOutput);
        LearnerVariantListImpl.MealyLearnerVariantListImpl variants = new LearnerVariantListImpl.MealyLearnerVariantListImpl();
        this.addLearnerVariants((Alphabet<I>)alphabet, (MembershipOracle.MealyMembershipOracle<I, O>)mqOracle, variants);
        StateLocalInputMealySimulatorEQOracle eqOracle = new StateLocalInputMealySimulatorEQOracle((MealyMachine)partialRef, alphabet, undefinedOutput);
        return LearnerITUtil.createExampleITCases(example, variants, eqOracle);
    }

    protected abstract <I, O> void addLearnerVariants(Alphabet<I> var1, MembershipOracle.MealyMembershipOracle<I, O> var2, LearnerVariantList.MealyLearnerVariantList<I, O> var3);
}

