/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.testsupport.it.learner;

import de.learnlib.api.query.DefaultQuery;
import de.learnlib.examples.DefaultPassiveLearningExample;
import de.learnlib.examples.LearningExample;
import de.learnlib.examples.LearningExamples;
import de.learnlib.testsupport.it.learner.LearnerITUtil;
import de.learnlib.testsupport.it.learner.PassiveLearnerVariantList;
import de.learnlib.testsupport.it.learner.PassiveLearnerVariantListImpl;
import de.learnlib.testsupport.it.learner.PassiveLearnerVariantTICase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.words.Alphabet;
import org.testng.annotations.Factory;

public abstract class AbstractDFAPassiveLearnerIT {
    @Factory
    public Object[] createExampleITCases() {
        ArrayList result = new ArrayList();
        List examples = LearningExamples.createDFAExamples();
        for (LearningExample.DFALearningExample example : examples) {
            result.addAll(this.createAllVariantsITCase(example));
        }
        return result.toArray();
    }

    private <I> List<PassiveLearnerVariantTICase<I, Boolean, DFA<?, I>>> createAllVariantsITCase(LearningExample.DFALearningExample<I> example) {
        Alphabet alphabet = example.getAlphabet();
        DFA reference = (DFA)example.getReferenceAutomaton();
        Collection<DefaultQuery<I, Boolean>> queries = this.generateSamplesInternal(alphabet, reference);
        PassiveLearnerVariantListImpl variants = new PassiveLearnerVariantListImpl();
        this.addLearnerVariants(alphabet, variants);
        DefaultPassiveLearningExample effectiveExample = new DefaultPassiveLearningExample(queries, alphabet);
        return LearnerITUtil.createPassiveExampleITCases(effectiveExample, variants);
    }

    protected <I> Collection<DefaultQuery<I, Boolean>> generateSamplesInternal(Alphabet<I> alphabet, DFA<?, I> reference) {
        return LearnerITUtil.generateSamples(alphabet, reference);
    }

    protected abstract <I> void addLearnerVariants(Alphabet<I> var1, PassiveLearnerVariantList<DFA<?, I>, I, Boolean> var2);
}

