/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.testsupport;

import com.google.common.io.CharStreams;
import de.learnlib.api.SUL;
import de.learnlib.api.algorithm.LearningAlgorithm;
import de.learnlib.api.oracle.EquivalenceOracle;
import de.learnlib.driver.util.MealySimulatorSUL;
import de.learnlib.examples.mealy.ExampleCoffeeMachine;
import de.learnlib.oracle.equivalence.SimulatorEQOracle;
import de.learnlib.util.Experiment;
import java.io.IOException;
import java.io.InputStream;
import net.automatalib.automata.UniversalDeterministicAutomaton;
import net.automatalib.automata.transducers.MealyMachine;
import net.automatalib.automata.transducers.impl.compact.CompactMealy;
import net.automatalib.commons.util.IOUtil;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;
import org.checkerframework.checker.initialization.qual.UnderInitialization;

public abstract class AbstractVisualizationTest<L extends LearningAlgorithm<? extends MealyMachine<?, ExampleCoffeeMachine.Input, ?, String>, ExampleCoffeeMachine.Input, Word<String>>> {
    protected final L learner;

    public AbstractVisualizationTest() {
        CompactMealy target = ExampleCoffeeMachine.constructMachine();
        Alphabet alphabet = target.getInputAlphabet();
        MealySimulatorSUL sul = new MealySimulatorSUL((MealyMachine)target);
        this.learner = this.getLearnerBuilder((Alphabet<ExampleCoffeeMachine.Input>)alphabet, (SUL<ExampleCoffeeMachine.Input, String>)sul);
        Experiment experiment = new Experiment(this.learner, (EquivalenceOracle)new SimulatorEQOracle((UniversalDeterministicAutomaton)target), alphabet);
        experiment.run();
    }

    protected String resourceAsString(String resourceName) throws IOException {
        try (InputStream is = this.getClass().getResourceAsStream(resourceName);){
            assert (is != null);
            String string = CharStreams.toString((Readable)IOUtil.asBufferedUTF8Reader((InputStream)is));
            return string;
        }
    }

    protected abstract L getLearnerBuilder(@UnderInitialization AbstractVisualizationTest<L> this, Alphabet<ExampleCoffeeMachine.Input> var1, SUL<ExampleCoffeeMachine.Input, String> var2);
}

