/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.testsupport;

import de.learnlib.api.Resumable;
import de.learnlib.api.algorithm.LearningAlgorithm;
import de.learnlib.api.oracle.EquivalenceOracle;
import de.learnlib.api.query.DefaultQuery;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import net.automatalib.automata.UniversalDeterministicAutomaton;
import net.automatalib.util.automata.Automata;
import net.automatalib.words.Alphabet;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class AbstractResumableLearnerTest<L extends Resumable<T> & LearningAlgorithm<M, I, D>, M extends UniversalDeterministicAutomaton<?, I, ?, ?, ?>, OR, I, D, T extends Serializable> {
    protected static final int RANDOM_SEED = 42;
    private M target;
    private L learner;
    private Alphabet<I> inputAlphabet;
    private int rounds;

    @BeforeClass
    public void setup() {
        this.inputAlphabet = this.getInitialAlphabet();
        this.target = this.getTarget(this.inputAlphabet);
        OR oracle = this.getOracle(this.target);
        this.learner = this.getLearner(oracle, this.inputAlphabet);
        this.rounds = this.getRounds();
    }

    protected abstract Alphabet<I> getInitialAlphabet();

    protected abstract M getTarget(Alphabet<I> var1);

    protected abstract OR getOracle(M var1);

    protected abstract EquivalenceOracle<M, I, D> getEquivalenceOracle(M var1);

    protected abstract L getLearner(OR var1, Alphabet<I> var2);

    protected abstract int getRounds();

    @Test
    public void testSuspendAndResumeLearner() throws Exception {
        UniversalDeterministicAutomaton hyp;
        DefaultQuery ce;
        UniversalDeterministicAutomaton hyp2;
        DefaultQuery ce2;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream objectOut = new ObjectOutputStream(byteOut);
        ((LearningAlgorithm)this.learner).startLearning();
        int roundsPre = 0;
        int roundsPost = 0;
        EquivalenceOracle<M, I, D> equivalenceOracle = this.getEquivalenceOracle(this.target);
        while ((ce2 = equivalenceOracle.findCounterExample((Object)(hyp2 = (UniversalDeterministicAutomaton)((LearningAlgorithm)this.learner).getHypothesisModel()), this.inputAlphabet)) != null) {
            ((LearningAlgorithm)this.learner).refineHypothesis(ce2);
            if (++roundsPre != this.rounds) continue;
            Serializable state = this.learner.suspend();
            objectOut.writeObject(state);
            objectOut.close();
        }
        ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
        ObjectInputStream objectIn = new ObjectInputStream(byteIn);
        Serializable serializedState = (Serializable)objectIn.readObject();
        objectIn.close();
        L learner2 = this.getLearner(this.getOracle(this.target), this.inputAlphabet);
        learner2.resume(serializedState);
        while ((ce = equivalenceOracle.findCounterExample((Object)(hyp = (UniversalDeterministicAutomaton)((LearningAlgorithm)learner2).getHypothesisModel()), this.inputAlphabet)) != null) {
            ((LearningAlgorithm)learner2).refineHypothesis(ce);
            ++roundsPost;
        }
        boolean modelsAreEquivalent = Automata.testEquivalence((UniversalDeterministicAutomaton)((UniversalDeterministicAutomaton)((LearningAlgorithm)this.learner).getHypothesisModel()), (UniversalDeterministicAutomaton)((UniversalDeterministicAutomaton)((LearningAlgorithm)learner2).getHypothesisModel()), this.inputAlphabet);
        Assert.assertTrue((boolean)modelsAreEquivalent);
        Assert.assertEquals((int)(roundsPre - roundsPost), (int)this.rounds);
    }
}

