/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.testsupport.it.learner;

import de.learnlib.api.LearningAlgorithm;
import de.learnlib.eqtests.basic.SimulatorEQOracle;
import de.learnlib.examples.LearningExample;
import de.learnlib.oracles.DefaultQuery;
import de.learnlib.testsupport.it.learner.LearnerVariant;
import java.util.Collection;
import net.automatalib.automata.UniversalDeterministicAutomaton;
import net.automatalib.automata.concepts.SuffixOutput;
import net.automatalib.util.automata.Automata;
import net.automatalib.words.Alphabet;
import org.testng.Assert;
import org.testng.ITest;
import org.testng.annotations.Test;

final class SingleLearnerVariantITSubCase<I, D, M extends UniversalDeterministicAutomaton<?, I, ?, ?, ?> & SuffixOutput<I, D>>
implements ITest {
    private final LearnerVariant<? extends M, I, D> variant;
    private final LearningExample<I, D, ? extends M> example;

    public SingleLearnerVariantITSubCase(LearnerVariant<? extends M, I, D> variant, LearningExample<I, D, ? extends M> example) {
        this.variant = variant;
        this.example = example;
    }

    public String getTestName() {
        return this.variant.getLearnerName() + "[" + this.variant.getName() + "]/" + this.example.getClass().getSimpleName();
    }

    @Test
    public void testLearning() {
        DefaultQuery ceQuery;
        System.out.print("Running learner integration test " + this.getTestName() + " ... ");
        System.out.flush();
        LearningAlgorithm<? extends M, I, D> learner = this.variant.getLearner();
        Alphabet alphabet = this.example.getAlphabet();
        int maxRounds = this.variant.getMaxRounds();
        if (maxRounds < 0) {
            maxRounds = ((UniversalDeterministicAutomaton)this.example.getReferenceAutomaton()).size();
        }
        SimulatorEQOracle eqOracle = new SimulatorEQOracle((UniversalDeterministicAutomaton)this.example.getReferenceAutomaton());
        long start = System.nanoTime();
        learner.startLearning();
        int roundCounter = 0;
        while ((ceQuery = eqOracle.findCounterExample(learner.getHypothesisModel(), (Collection)alphabet)) != null) {
            if (++roundCounter > maxRounds) {
                Assert.fail((String)("Learning took too many rounds (> " + maxRounds + ")"));
            }
            boolean refined = learner.refineHypothesis(ceQuery);
            Assert.assertTrue((boolean)refined, (String)("Real counterexample " + ceQuery.getInput() + " did not refine hypothesis"));
        }
        Assert.assertNull((Object)Automata.findSeparatingWord((UniversalDeterministicAutomaton)((UniversalDeterministicAutomaton)this.example.getReferenceAutomaton()), (UniversalDeterministicAutomaton)((UniversalDeterministicAutomaton)learner.getHypothesisModel()), (Collection)alphabet), (String)"Final hypothesis does not match reference automaton");
        long duration = (System.nanoTime() - start) / 1000000L;
        System.out.printf("ok [%d.%03ds]", duration / 1000L, duration % 1000L);
        System.out.println();
    }
}

