/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.testsupport.it.learner;

import de.learnlib.api.LearningAlgorithm;
import de.learnlib.mealy.MealyUtil;
import de.learnlib.testsupport.it.learner.LearnerVariant;
import de.learnlib.testsupport.it.learner.LearnerVariantList;
import java.util.ArrayList;
import java.util.List;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.transout.MealyMachine;
import net.automatalib.words.Word;

class LearnerVariantListImpl<M, I, O>
implements LearnerVariantList<M, I, O> {
    private final List<LearnerVariant<M, I, O>> learnerVariants = new ArrayList<LearnerVariant<M, I, O>>();

    LearnerVariantListImpl() {
    }

    @Override
    public void addLearnerVariant(String name, LearningAlgorithm<? extends M, I, O> learner) {
        this.addLearnerVariant(name, learner, -1);
    }

    @Override
    public void addLearnerVariant(String name, LearningAlgorithm<? extends M, I, O> learner, int maxRounds) {
        LearnerVariant<? extends M, I, O> variant = new LearnerVariant<M, I, O>(name, learner, maxRounds);
        this.learnerVariants.add(variant);
    }

    public List<? extends LearnerVariant<M, I, O>> getLearnerVariants() {
        return this.learnerVariants;
    }

    public static class MealySymLearnerVariantListImpl<I, O>
    implements LearnerVariantList.MealySymLearnerVariantList<I, O> {
        private final MealyLearnerVariantListImpl<I, O> mealyLearnerVariants = new MealyLearnerVariantListImpl();

        public MealyLearnerVariantListImpl<I, O> getMealyLearnerVariants() {
            return this.mealyLearnerVariants;
        }

        @Override
        public void addLearnerVariant(String name, LearningAlgorithm<? extends MealyMachine<?, I, ?, O>, I, O> learner) {
            this.addLearnerVariant(name, learner, -1);
        }

        @Override
        public void addLearnerVariant(String name, LearningAlgorithm<? extends MealyMachine<?, I, ?, O>, I, O> learner, int maxRounds) {
            this.mealyLearnerVariants.addLearnerVariant(name, MealyUtil.wrapSymbolLearner(learner), maxRounds);
        }
    }

    public static class MealyLearnerVariantListImpl<I, O>
    extends LearnerVariantListImpl<MealyMachine<?, I, ?, O>, I, Word<O>>
    implements LearnerVariantList.MealyLearnerVariantList<I, O> {
    }

    public static class DFALearnerVariantListImpl<I>
    extends LearnerVariantListImpl<DFA<?, I>, I, Boolean>
    implements LearnerVariantList.DFALearnerVariantList<I> {
    }
}

