/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.util.statistic;

import de.learnlib.filter.statistic.Counter;
import de.learnlib.logging.Category;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SimpleProfiler {
    private static final Map<String, Counter> CUMULATED = new ConcurrentHashMap<String, Counter>();
    private static final Map<String, Long> PENDING = new ConcurrentHashMap<String, Long>();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)SimpleProfiler.class.getName());
    private static final double MILLISECONDS_PER_SECOND = 1000.0;

    private SimpleProfiler() {
    }

    public static void reset() {
        CUMULATED.clear();
        PENDING.clear();
    }

    public static void start(String name) {
        PENDING.put(name, System.currentTimeMillis());
    }

    public static void stop(String name) {
        Long start = PENDING.remove(name);
        if (start == null) {
            return;
        }
        long duration = System.currentTimeMillis() - start;
        Counter sum = CUMULATED.computeIfAbsent(name, k -> new Counter(k, "ms"));
        sum.increment(duration);
    }

    public static @Nullable Counter cumulated(String name) {
        return CUMULATED.get(name);
    }

    public static void logResults() {
        for (Counter c : CUMULATED.values()) {
            LOGGER.info(Category.PROFILING, "{}, ({} s)", (Object)c.getSummary(), (Object)((double)c.getCount() / 1000.0));
        }
    }
}

