/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.util.nfa;

import de.learnlib.algorithm.LearningAlgorithm;
import de.learnlib.query.DefaultQuery;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.fsa.NFA;
import net.automatalib.automaton.fsa.impl.CompactDFA;
import net.automatalib.util.automaton.fsa.NFAs;

public class NFALearnerWrapper<I>
implements LearningAlgorithm.DFALearner<I> {
    private final Alphabet<I> alphabet;
    private final LearningAlgorithm<? extends NFA<?, I>, I, Boolean> nfaLearner;

    public NFALearnerWrapper(Alphabet<I> alphabet, LearningAlgorithm<? extends NFA<?, I>, I, Boolean> nfaLearner) {
        this.alphabet = alphabet;
        this.nfaLearner = nfaLearner;
    }

    public void startLearning() {
        this.nfaLearner.startLearning();
    }

    public boolean refineHypothesis(DefaultQuery<I, Boolean> ceQuery) {
        return this.nfaLearner.refineHypothesis(ceQuery);
    }

    public CompactDFA<I> getHypothesisModel() {
        NFA nfaHyp = (NFA)this.nfaLearner.getHypothesisModel();
        return NFAs.determinize((NFA)nfaHyp, this.alphabet);
    }

    public String toString() {
        return this.nfaLearner.toString();
    }
}

