/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.util.moore;

import de.learnlib.algorithm.LearningAlgorithm;
import de.learnlib.query.DefaultQuery;
import de.learnlib.util.moore.MooreUtil;
import net.automatalib.automaton.transducer.MooreMachine;
import net.automatalib.word.Word;

final class MooreLearnerWrapper<M extends MooreMachine<?, I, ?, O>, I, O>
implements LearningAlgorithm.MooreLearner<I, O> {
    private final LearningAlgorithm<M, I, O> learner;

    MooreLearnerWrapper(LearningAlgorithm<M, I, O> learner) {
        this.learner = learner;
    }

    public void startLearning() {
        this.learner.startLearning();
    }

    public boolean refineHypothesis(DefaultQuery<I, Word<O>> ceQuery) {
        MooreMachine hyp = (MooreMachine)this.learner.getHypothesisModel();
        DefaultQuery<I, O> reducedQry = MooreUtil.reduceCounterExample(hyp, ceQuery);
        return reducedQry != null && this.learner.refineHypothesis(reducedQry);
    }

    public M getHypothesisModel() {
        return (M)((MooreMachine)this.learner.getHypothesisModel());
    }
}

