/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.util.mealy;

import de.learnlib.query.AdaptiveQuery;
import de.learnlib.query.Query;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;

public class PresetAdaptiveQuery<I, O>
implements AdaptiveQuery<I, O> {
    private final WordBuilder<O> builder = new WordBuilder();
    private final Query<I, Word<O>> query;
    private final Word<I> prefix;
    private final Word<I> suffix;
    private int prefixIdx;
    private int suffixIdx;

    public PresetAdaptiveQuery(Query<I, Word<O>> query) {
        this.query = query;
        this.prefix = query.getPrefix();
        this.suffix = query.getSuffix();
        this.prefixIdx = 0;
        this.suffixIdx = 0;
    }

    public I getInput() {
        if (this.prefixIdx < this.prefix.size()) {
            return (I)this.prefix.getSymbol(this.prefixIdx);
        }
        return (I)this.suffix.getSymbol(this.suffixIdx);
    }

    public AdaptiveQuery.Response processOutput(O out) {
        if (this.prefixIdx < this.prefix.size()) {
            ++this.prefixIdx;
        } else {
            ++this.suffixIdx;
            this.builder.add(out);
            if (this.suffixIdx >= this.suffix.size()) {
                this.query.answer((Object)this.builder.toWord());
                return AdaptiveQuery.Response.FINISHED;
            }
        }
        return AdaptiveQuery.Response.SYMBOL;
    }
}

