/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.util.statistics;

import de.learnlib.api.logging.LearnLogger;
import de.learnlib.api.statistic.StatisticData;
import de.learnlib.filter.statistic.Counter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class SimpleProfiler {
    private static final Map<String, Counter> CUMULATED = new ConcurrentHashMap<String, Counter>();
    private static final Map<String, Long> PENDING = new ConcurrentHashMap<String, Long>();
    private static final LearnLogger LOGGER = LearnLogger.getLogger((String)SimpleProfiler.class.getName());
    private static final double MILLISECONDS_PER_SECOND = 1000.0;

    private SimpleProfiler() {
    }

    public static void reset() {
        CUMULATED.clear();
        PENDING.clear();
    }

    public static void start(String name) {
        PENDING.put(name, System.currentTimeMillis());
    }

    public static void stop(String name) {
        Long start = PENDING.remove(name);
        if (start == null) {
            return;
        }
        long duration = System.currentTimeMillis() - start;
        Counter sum = CUMULATED.computeIfAbsent(name, k -> new Counter(k, "ms"));
        sum.increment(duration);
    }

    public static Counter cumulated(String name) {
        return CUMULATED.get(name);
    }

    @Nonnull
    public static String getResults() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Counter> e : CUMULATED.entrySet()) {
            sb.append(e.getValue().getSummary()).append(", (").append((double)e.getValue().getCount() / 1000.0).append(" s)").append(System.lineSeparator());
        }
        return sb.toString();
    }

    public static void logResults() {
        for (Map.Entry<String, Counter> e : CUMULATED.entrySet()) {
            LOGGER.logProfilingInfo((StatisticData)e.getValue());
        }
    }
}

