/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.util.mealy;

import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.api.query.Query;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.words.Word;

@ParametersAreNonnullByDefault
final class SymbolOracleWrapper<I, O>
implements MembershipOracle<I, O> {
    private final MembershipOracle<I, Word<O>> wordOracle;

    SymbolOracleWrapper(MembershipOracle<I, Word<O>> wordOracle) {
        this.wordOracle = wordOracle;
    }

    public void processQueries(Collection<? extends Query<I, O>> queries) {
        ArrayList<LastSymbolQuery<I, O>> lsQueries = new ArrayList<LastSymbolQuery<I, O>>(queries.size());
        for (Query<I, O> qry : queries) {
            lsQueries.add(new LastSymbolQuery<I, O>(qry));
        }
        this.wordOracle.processQueries(lsQueries);
    }

    @ParametersAreNonnullByDefault
    private static final class LastSymbolQuery<I, O>
    extends Query<I, Word<O>> {
        private final Query<I, O> originalQuery;

        LastSymbolQuery(Query<I, O> originalQuery) {
            this.originalQuery = originalQuery;
        }

        public void answer(Word<O> output) {
            if (output == null) {
                throw new IllegalArgumentException("Query answer words must not be null");
            }
            this.originalQuery.answer(output.isEmpty() ? null : output.lastSymbol());
        }

        @Nonnull
        public Word<I> getPrefix() {
            return this.originalQuery.getPrefix();
        }

        @Nonnull
        public Word<I> getSuffix() {
            return this.originalQuery.getSuffix();
        }

        public String toString() {
            return this.originalQuery.toString();
        }
    }
}

