/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.util.mealy;

import de.learnlib.api.algorithm.LearningAlgorithm;
import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.api.query.DefaultQuery;
import de.learnlib.util.mealy.MealyLearnerWrapper;
import de.learnlib.util.mealy.SymbolOracleWrapper;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.automata.transducers.MealyMachine;
import net.automatalib.words.Word;

@ParametersAreNonnullByDefault
public final class MealyUtil {
    public static final int NO_MISMATCH = -1;

    private MealyUtil() {
        throw new IllegalStateException("Constructor should never be invoked");
    }

    public static <I, O> int findMismatch(MealyMachine<?, I, ?, O> hypothesis, Word<I> input, Word<O> output) {
        return MealyUtil.doFindMismatch(hypothesis, input, output);
    }

    public static <O> int findMismatch(Word<O> out1, Word<O> out2) {
        int len = out1.length();
        assert (len == out2.length());
        for (int i = 0; i < len; ++i) {
            Object sym2;
            Object sym1 = out1.getSymbol(i);
            if (Objects.equals(sym1, sym2 = out2.getSymbol(i))) continue;
            return i;
        }
        return -1;
    }

    private static <S, I, T, O> int doFindMismatch(MealyMachine<S, I, T, O> hypothesis, Word<I> input, Word<O> output) {
        int i = 0;
        Object state = hypothesis.getInitialState();
        Iterator inIt = input.iterator();
        Iterator outIt = output.iterator();
        while (inIt.hasNext() && outIt.hasNext()) {
            Object trans = hypothesis.getTransition(state, inIt.next());
            Object ceOut = outIt.next();
            Object transOut = hypothesis.getTransitionOutput(trans);
            if (!Objects.equals(transOut, ceOut)) {
                return i;
            }
            state = hypothesis.getSuccessor(trans);
            ++i;
        }
        return -1;
    }

    @Nullable
    public static <I, O> DefaultQuery<I, Word<O>> shortenCounterExample(MealyMachine<?, I, ?, O> hypothesis, DefaultQuery<I, Word<O>> ceQuery) {
        Word cePrefix = ceQuery.getPrefix();
        Word ceSuffix = ceQuery.getSuffix();
        Word hypOut = (Word)hypothesis.computeSuffixOutput((Iterable)cePrefix, (Iterable)ceSuffix);
        Word ceOut = (Word)ceQuery.getOutput();
        assert (ceOut.length() == hypOut.length());
        int mismatchIdx = MealyUtil.findMismatch(hypOut, ceOut);
        if (mismatchIdx == -1) {
            return null;
        }
        return new DefaultQuery(cePrefix, ceSuffix.prefix(mismatchIdx + 1), (Object)ceOut.prefix(mismatchIdx + 1));
    }

    @Nullable
    public static <I, O> DefaultQuery<I, O> reduceCounterExample(MealyMachine<?, I, ?, O> hypothesis, DefaultQuery<I, Word<O>> ceQuery) {
        Word cePrefix = ceQuery.getPrefix();
        Word ceSuffix = ceQuery.getSuffix();
        Word hypOut = (Word)hypothesis.computeSuffixOutput((Iterable)cePrefix, (Iterable)ceSuffix);
        Word ceOut = (Word)ceQuery.getOutput();
        assert (ceOut.length() == hypOut.length());
        int mismatchIdx = MealyUtil.findMismatch(hypOut, ceOut);
        if (mismatchIdx == -1) {
            return null;
        }
        return new DefaultQuery(cePrefix, ceSuffix.prefix(mismatchIdx + 1), ceOut.getSymbol(mismatchIdx));
    }

    @Nonnull
    public static <M extends MealyMachine<?, I, ?, O>, I, O> LearningAlgorithm.MealyLearner<I, O> wrapSymbolLearner(LearningAlgorithm<M, I, O> learner) {
        return new MealyLearnerWrapper<M, I, O>(learner);
    }

    @Nonnull
    public static <I, O> MembershipOracle<I, O> wrapWordOracle(MembershipOracle<I, Word<O>> oracle) {
        return new SymbolOracleWrapper<I, O>(oracle);
    }
}

