/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.util.mealy;

import de.learnlib.api.algorithm.LearningAlgorithm;
import de.learnlib.api.query.DefaultQuery;
import de.learnlib.util.mealy.MealyUtil;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.automata.transducers.MealyMachine;
import net.automatalib.words.Word;

@ParametersAreNonnullByDefault
final class MealyLearnerWrapper<M extends MealyMachine<?, I, ?, O>, I, O>
implements LearningAlgorithm.MealyLearner<I, O> {
    private final LearningAlgorithm<M, I, O> learner;
    private M hypothesis;

    MealyLearnerWrapper(LearningAlgorithm<M, I, O> learner) {
        this.learner = learner;
    }

    public void startLearning() {
        this.learner.startLearning();
    }

    public boolean refineHypothesis(DefaultQuery<I, Word<O>> ceQuery) {
        DefaultQuery<I, O> reducedQry;
        if (this.hypothesis == null) {
            this.hypothesis = (MealyMachine)this.learner.getHypothesisModel();
        }
        if ((reducedQry = MealyUtil.reduceCounterExample(this.hypothesis, ceQuery)) == null) {
            return false;
        }
        this.hypothesis = null;
        return this.learner.refineHypothesis(reducedQry);
    }

    @Nonnull
    public M getHypothesisModel() {
        this.hypothesis = (MealyMachine)this.learner.getHypothesisModel();
        return this.hypothesis;
    }
}

