/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.util;

import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.api.oracle.OmegaQueryAnswerer;
import de.learnlib.api.oracle.QueryAnswerer;
import de.learnlib.api.query.DefaultQuery;
import de.learnlib.api.query.OmegaQuery;
import de.learnlib.api.query.Query;
import de.learnlib.setting.LearnLibProperty;
import de.learnlib.setting.LearnLibSettings;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.automata.concepts.SuffixOutput;
import net.automatalib.commons.util.Pair;
import net.automatalib.words.Word;

@ParametersAreNonnullByDefault
public final class MQUtil {
    public static final int PARALLEL_THRESHOLD;

    private MQUtil() {
    }

    @Deprecated
    @Nullable
    public static <I, D> D output(MembershipOracle<I, D> oracle, Word<I> queryWord) {
        return (D)oracle.answerQuery(queryWord);
    }

    @Deprecated
    @Nullable
    public static <I, D> D output(MembershipOracle<I, D> oracle, Word<I> prefix, Word<I> suffix) {
        return (D)oracle.answerQuery(prefix, suffix);
    }

    public static <I, D> DefaultQuery<I, D> normalize(MembershipOracle<I, D> oracle, DefaultQuery<I, D> query) {
        if (query.isNormalized()) {
            return query;
        }
        return MQUtil.query(oracle, Word.epsilon(), query.getInput());
    }

    @Nonnull
    public static <I, D> DefaultQuery<I, D> query(MembershipOracle<I, D> oracle, Word<I> prefix, Word<I> suffix) {
        DefaultQuery qry = new DefaultQuery(prefix, suffix);
        oracle.processQuery((Query)qry);
        return qry;
    }

    @Nonnull
    public static <I, D> DefaultQuery<I, D> query(MembershipOracle<I, D> oracle, Word<I> queryWord) {
        return MQUtil.query(oracle, Word.epsilon(), queryWord);
    }

    public static <I, D> void answerQueriesAuto(QueryAnswerer<I, D> answerer, Collection<? extends Query<I, D>> queries) {
        if (PARALLEL_THRESHOLD < 0 || queries.size() < PARALLEL_THRESHOLD) {
            MQUtil.answerQueries(answerer, queries);
        } else {
            MQUtil.answerQueriesParallel(answerer, queries);
        }
    }

    public static <S, I, D> void answerOmegaQueriesAuto(OmegaQueryAnswerer<S, I, D> answerer, Collection<? extends OmegaQuery<I, D>> queries) {
        if (PARALLEL_THRESHOLD < 0 || queries.size() < PARALLEL_THRESHOLD) {
            MQUtil.answerOmegaQueries(answerer, queries);
        } else {
            MQUtil.answerOmegaQueriesParallel(answerer, queries);
        }
    }

    public static <I, D> void answerQueries(QueryAnswerer<I, D> answerer, Collection<? extends Query<I, D>> queries) {
        for (Query<I, D> query : queries) {
            Word prefix = query.getPrefix();
            Word suffix = query.getSuffix();
            Object answer = answerer.answerQuery(prefix, suffix);
            query.answer(answer);
        }
    }

    public static <S, I, D> void answerOmegaQueries(OmegaQueryAnswerer<S, I, D> answerer, Collection<? extends OmegaQuery<I, D>> queries) {
        for (OmegaQuery<I, D> query : queries) {
            Word prefix = query.getPrefix();
            Word loop = query.getLoop();
            int repeat = query.getRepeat();
            Pair answer = answerer.answerQuery(prefix, loop, repeat);
            query.answer(answer.getFirst(), ((Integer)answer.getSecond()).intValue());
        }
    }

    public static <I, D> void answerQueriesParallel(QueryAnswerer<I, D> answerer, Collection<? extends Query<I, D>> queries) {
        queries.parallelStream().forEach(q -> {
            Word prefix = q.getPrefix();
            Word suffix = q.getSuffix();
            Object answer = answerer.answerQuery(prefix, suffix);
            q.answer(answer);
        });
    }

    public static <S, I, D> void answerOmegaQueriesParallel(OmegaQueryAnswerer<S, I, D> answerer, Collection<? extends OmegaQuery<I, D>> queries) {
        queries.parallelStream().forEach(q -> {
            Word prefix = q.getPrefix();
            Word loop = q.getLoop();
            int repeat = q.getRepeat();
            Pair answer = answerer.answerQuery(prefix, loop, repeat);
            q.answer(answer.getFirst(), ((Integer)answer.getSecond()).intValue());
        });
    }

    public static <I, D> boolean isCounterexample(DefaultQuery<I, D> query, SuffixOutput<I, D> hyp) {
        Object hypOut;
        Object qryOut = query.getOutput();
        return !Objects.equals(qryOut, hypOut = hyp.computeSuffixOutput((Iterable)query.getPrefix(), (Iterable)query.getSuffix()));
    }

    static {
        LearnLibSettings settings = LearnLibSettings.getInstance();
        PARALLEL_THRESHOLD = settings.getInt(LearnLibProperty.PARALLEL_QUERIES_THRESHOLD, -1);
    }
}

