/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.util;

import de.learnlib.api.oracle.AutomatonOracle;
import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.api.query.DefaultQuery;
import de.learnlib.api.query.Query;
import java.util.LinkedList;
import java.util.Queue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.automata.DeterministicAutomaton;
import net.automatalib.words.Word;

@ParametersAreNonnullByDefault
public abstract class AbstractBFOracle<A extends DeterministicAutomaton<?, I, ?>, I, D>
implements AutomatonOracle<A, I, D> {
    private final Queue<Word<I>> queue = new LinkedList<Word<I>>();
    private final MembershipOracle<I, D> membershipOracle;
    private double multiplier;

    protected AbstractBFOracle(MembershipOracle<I, D> membershipOracle, double multiplier) {
        this.membershipOracle = membershipOracle;
        this.multiplier = multiplier;
    }

    public DefaultQuery<I, D> processInput(A hypothesis, Word<I> input) {
        DefaultQuery query = new DefaultQuery(input);
        this.membershipOracle.processQuery((Query)query);
        return query;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(double multiplier) {
        this.multiplier = multiplier;
    }

    public MembershipOracle<I, D> getMembershipOracle() {
        return this.membershipOracle;
    }

    @Nullable
    public Word<I> nextInput() {
        return this.queue.poll();
    }

    public void addWord(Word<I> input) {
        this.queue.add(input);
    }

    public void pre() {
        this.queue.clear();
        this.addWord(Word.epsilon());
    }
}

