/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.ttt.mealy;

import de.learnlib.acex.AcexAnalyzer;
import de.learnlib.acex.MealyOutInconsPrefixTransformAcex;
import de.learnlib.acex.OutInconsPrefixTransformAcex;
import de.learnlib.algorithm.LearningAlgorithm;
import de.learnlib.algorithm.ttt.base.AbstractBaseDTNode;
import de.learnlib.algorithm.ttt.base.AbstractTTTLearner;
import de.learnlib.algorithm.ttt.base.BaseTTTDiscriminationTree;
import de.learnlib.algorithm.ttt.base.OutputInconsistency;
import de.learnlib.algorithm.ttt.base.TTTState;
import de.learnlib.algorithm.ttt.base.TTTTransition;
import de.learnlib.algorithm.ttt.mealy.TTTDTNodeMealy;
import de.learnlib.algorithm.ttt.mealy.TTTHypothesisMealy;
import de.learnlib.algorithm.ttt.mealy.TTTTransitionMealy;
import de.learnlib.datastructure.discriminationtree.model.AbstractDTNode;
import de.learnlib.datastructure.list.IntrusiveListEntry;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.DefaultQuery;
import de.learnlib.query.Query;
import de.learnlib.util.mealy.MealyUtil;
import java.util.ArrayList;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;

public class TTTLearnerMealy<I, O>
extends AbstractTTTLearner<MealyMachine<?, I, ?, O>, I, Word<O>>
implements LearningAlgorithm.MealyLearner<I, O> {
    public TTTLearnerMealy(Alphabet<I> alphabet, MembershipOracle<I, Word<O>> oracle, AcexAnalyzer analyzer) {
        super(alphabet, oracle, new TTTHypothesisMealy(alphabet), new BaseTTTDiscriminationTree<I, Word<O>>(oracle, TTTDTNodeMealy::new), analyzer);
    }

    public MealyMachine<?, I, ?, O> getHypothesisModel() {
        return (TTTHypothesisMealy)this.hypothesis;
    }

    @Override
    protected TTTTransition<I, Word<O>> createTransition(TTTState<I, Word<O>> state, I sym) {
        return new TTTTransitionMealy<I, O>(state, sym);
    }

    @Override
    protected void initTransitions(TTTTransition<I, Word<O>> head, int num) {
        ArrayList queries = new ArrayList(num);
        IntrusiveListEntry iter = head;
        for (int i = 0; i < num; ++i) {
            assert (iter != null);
            queries.add(new TransitionOutputQuery((TTTTransitionMealy)((Object)iter.getElement())));
            iter = (IntrusiveListEntry)iter.getNext();
        }
        this.oracle.processQueries(queries);
    }

    @Override
    protected boolean refineHypothesisSingle(DefaultQuery<I, Word<O>> ceQuery) {
        DefaultQuery shortenedCeQuery = MealyUtil.shortenCounterExample((MealyMachine)((TTTHypothesisMealy)this.hypothesis), ceQuery);
        return shortenedCeQuery != null && super.refineHypothesisSingle(shortenedCeQuery);
    }

    @Override
    protected OutInconsPrefixTransformAcex<I, Word<O>> deriveAcex(OutputInconsistency<I, Word<O>> outIncons) {
        TTTState source = outIncons.srcState;
        Word suffix = outIncons.suffix;
        MealyOutInconsPrefixTransformAcex acex = new MealyOutInconsPrefixTransformAcex(suffix, this.oracle, w -> this.getDeterministicState(source, w).getAccessSequence());
        acex.setEffect(0, (Object)((Word)outIncons.targetOut));
        Word<O> lastHypOut = this.computeHypothesisOutput((TTTState<I, Word<O>>)this.getAnySuccessor(source, suffix.prefix(-1)), (Word<I>)suffix.suffix(1));
        acex.setEffect(suffix.length() - 1, lastHypOut);
        return acex;
    }

    @Override
    protected Word<O> succEffect(Word<O> effect) {
        return effect.subWord(1);
    }

    @Override
    protected OutputInconsistency<I, Word<O>> findOutputInconsistency() {
        OutputInconsistency best = null;
        for (TTTState state : this.hypothesis.getStates()) {
            AbstractBaseDTNode node = state.getDTLeaf();
            while (!node.isRoot()) {
                Word suffix;
                Word<O> hypOut;
                Word expectedOut = (Word)node.getParentOutcome();
                int mismatchIdx = MealyUtil.findMismatch((Word)expectedOut, hypOut = this.computeHypothesisOutput((TTTState<I, Word<O>>)state, (Word<I>)(suffix = (Word)(node = (AbstractBaseDTNode)node.getParent()).getDiscriminator())));
                if (mismatchIdx == -1 || best != null && mismatchIdx > best.suffix.length()) continue;
                best = new OutputInconsistency(state, suffix.prefix(mismatchIdx + 1), expectedOut.prefix(mismatchIdx + 1));
            }
        }
        return best;
    }

    @Override
    protected Word<O> predictSuccOutcome(TTTTransition<I, Word<O>> trans, AbstractBaseDTNode<I, Word<O>> succSeparator) {
        TTTTransitionMealy mtrans = (TTTTransitionMealy)trans;
        if (succSeparator == null) {
            return Word.fromLetter(mtrans.output);
        }
        Word subtreeLabel = (Word)succSeparator.subtreeLabel((AbstractDTNode)trans.getDTTarget());
        assert (subtreeLabel != null);
        return subtreeLabel.prepend(mtrans.output);
    }

    @Override
    protected Word<O> computeHypothesisOutput(TTTState<I, Word<O>> state, Word<I> suffix) {
        TTTState<I, Object> curr = state;
        WordBuilder wb = new WordBuilder(suffix.length());
        for (Object sym : suffix) {
            TTTTransitionMealy trans = (TTTTransitionMealy)this.hypothesis.getInternalTransition(curr, sym);
            wb.append(trans.output);
            curr = this.getAnyTarget(trans);
        }
        return wb.toWord();
    }

    @Override
    protected AbstractBaseDTNode<I, Word<O>> createNewNode(AbstractBaseDTNode<I, Word<O>> parent, Word<O> parentOutput) {
        return new TTTDTNodeMealy<I, Word<O>>(parent, parentOutput);
    }

    private static final class TransitionOutputQuery<I, O>
    extends Query<I, Word<O>> {
        private final TTTTransitionMealy<I, O> transition;

        TransitionOutputQuery(TTTTransitionMealy<I, O> transition) {
            this.transition = transition;
        }

        public void answer(Word<O> output) {
            this.transition.output = output.firstSymbol();
        }

        public Word<I> getPrefix() {
            return this.transition.getSource().getAccessSequence();
        }

        public Word<I> getSuffix() {
            return Word.fromLetter(this.transition.getInput());
        }
    }
}

