/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.ttt.dfa;

import de.learnlib.acex.AbstractCounterexample;
import de.learnlib.acex.AcexAnalyzer;
import de.learnlib.algorithm.ttt.base.AbstractBaseDTNode;
import de.learnlib.algorithm.ttt.base.TTTState;
import de.learnlib.algorithm.ttt.base.TTTTransition;
import de.learnlib.algorithm.ttt.dfa.TTTDTNodeDFA;
import de.learnlib.algorithm.ttt.dfa.TTTLearnerDFA;
import de.learnlib.algorithm.ttt.dfa.TTTStateDFA;
import de.learnlib.datastructure.discriminationtree.model.AbstractDTNode;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.DefaultQuery;
import java.util.Iterator;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.common.util.array.ArrayStorage;
import net.automatalib.common.util.collection.AbstractSimplifiedIterator;
import net.automatalib.word.Word;

public class PrefixTTTLearnerDFA<I>
extends TTTLearnerDFA<I> {
    private final ExtDTNode<I> unlabeledList = new ExtDTNode();

    public PrefixTTTLearnerDFA(Alphabet<I> alphabet, MembershipOracle<I, Boolean> oracle, AcexAnalyzer analyzer) {
        super(alphabet, oracle, analyzer, ExtDTNode::new);
    }

    @Override
    public boolean refineHypothesis(DefaultQuery<I, Boolean> ceQuery) {
        boolean refined = this.refineHypothesisSingle(ceQuery);
        if (!refined) {
            return false;
        }
        while (this.refineHypothesisSingle(ceQuery)) {
        }
        return true;
    }

    @Override
    protected boolean refineHypothesisSingle(DefaultQuery<I, Boolean> ceQuery) {
        if (this.getHypothesisModel().computeSuffixOutput((Iterable)ceQuery.getPrefix(), (Iterable)ceQuery.getSuffix()).equals(ceQuery.getOutput())) {
            return false;
        }
        Word ceWord = ceQuery.getInput();
        int currReachInconsLength = ceWord.length();
        EasyTTTPrefAcex acex = new EasyTTTPrefAcex(ceWord);
        do {
            acex.update(currReachInconsLength);
            int breakpoint = this.analyzer.analyzeAbstractCounterexample((AbstractCounterexample)acex, 0, currReachInconsLength);
            ExtDTNode toSplit = acex.getHypNode(breakpoint);
            TTTState splitState = (TTTState)toSplit.getData();
            ExtDTNode lca = acex.getLCA(breakpoint + 1);
            Object sym = ceWord.getSymbol(breakpoint);
            Word newDiscr = ((Word)lca.getDiscriminator()).prepend(sym);
            ExtDTNode succHyp = acex.getHypNode(breakpoint + 1);
            Boolean hypOut = (Boolean)lca.subtreeLabel((AbstractDTNode)succHyp);
            assert (hypOut != null);
            this.openTransitions.concat(toSplit.getIncoming());
            AbstractDTNode.SplitResult splitResult = toSplit.split(newDiscr, hypOut, hypOut == false);
            PrefixTTTLearnerDFA.link((AbstractBaseDTNode)splitResult.nodeOld, splitState);
            ExtDTNode extUnlabeled = (ExtDTNode)splitResult.nodeNew;
            extUnlabeled.tempPrefix = currReachInconsLength;
            this.unlabeledList.addUnlabeled(extUnlabeled);
            this.closeTransitions();
        } while ((currReachInconsLength = this.findMinReachIncons()) != -1);
        return true;
    }

    @Override
    protected TTTState<I, Boolean> makeTree(TTTTransition<I, Boolean> trans) {
        ExtDTNode node = (ExtDTNode)trans.getNonTreeTarget();
        if (node.tempPrefix != -1) {
            node.removeFromUnlabeledList();
        }
        return super.makeTree(trans);
    }

    private int findMinReachIncons() {
        int minLength = -1;
        for (ExtDTNode<I> n : this.unlabeledList.unlabeled()) {
            int len = ((ExtDTNode)n).tempPrefix;
            if (minLength != -1 && len >= minLength) continue;
            minLength = len;
        }
        return minLength;
    }

    private final class EasyTTTPrefAcex
    implements AbstractCounterexample<Boolean> {
        private final Word<I> ceWord;
        private final ArrayStorage<ExtDTNode<I>> hypNodes;
        private final ArrayStorage<ExtDTNode<I>> siftNodes;

        EasyTTTPrefAcex(Word<I> ceWord) {
            this.ceWord = ceWord;
            this.hypNodes = new ArrayStorage(ceWord.length() + 1);
            this.siftNodes = new ArrayStorage(ceWord.length() + 1);
            this.update(ceWord.length());
        }

        public void update(int len) {
            TTTStateDFA curr = (TTTStateDFA)PrefixTTTLearnerDFA.this.hypothesis.getInitialState();
            assert (curr != null);
            this.hypNodes.set(0, (Object)((ExtDTNode)curr.getDTLeaf()));
            this.siftNodes.set(0, (Object)((ExtDTNode)curr.getDTLeaf()));
            boolean wasTree = true;
            for (int i = 0; i < len; ++i) {
                Object sym = this.ceWord.getSymbol(i);
                TTTTransition trans = PrefixTTTLearnerDFA.this.hypothesis.getInternalTransition(curr, sym);
                curr = (TTTStateDFA)trans.getTarget();
                this.hypNodes.set(i + 1, (Object)((ExtDTNode)curr.getDTLeaf()));
                if (!wasTree) continue;
                this.siftNodes.set(i + 1, (Object)((ExtDTNode)curr.getDTLeaf()));
                if (trans.isTree()) continue;
                wasTree = false;
            }
        }

        public int getLength() {
            return this.ceWord.length() + 1;
        }

        public boolean checkEffects(Boolean eff1, Boolean eff2) {
            return eff1 == false || eff2 != false;
        }

        public Boolean effect(int index) {
            ExtDTNode hypNode = (ExtDTNode)((Object)this.hypNodes.get(index));
            ExtDTNode siftNode = (ExtDTNode)((Object)this.siftNodes.get(index));
            if (siftNode == null) {
                siftNode = (ExtDTNode)PrefixTTTLearnerDFA.this.dtree.getRoot();
            }
            ExtDTNode lca = (ExtDTNode)PrefixTTTLearnerDFA.this.dtree.leastCommonAncestor((AbstractDTNode)hypNode, (AbstractDTNode)siftNode);
            Word cePref = this.ceWord.prefix(index);
            while (lca == siftNode && siftNode != hypNode) {
                Boolean out = (Boolean)PrefixTTTLearnerDFA.this.oracle.answerQuery(cePref, (Word)siftNode.getDiscriminator());
                siftNode = (ExtDTNode)siftNode.getChild(out);
                lca = (ExtDTNode)PrefixTTTLearnerDFA.this.dtree.leastCommonAncestor((AbstractDTNode)hypNode, (AbstractDTNode)siftNode);
            }
            this.siftNodes.set(index, (Object)siftNode);
            return siftNode == hypNode;
        }

        public ExtDTNode<I> getLCA(int index) {
            return (ExtDTNode)PrefixTTTLearnerDFA.this.dtree.leastCommonAncestor((AbstractDTNode)((AbstractBaseDTNode)((Object)this.hypNodes.get(index))), (AbstractDTNode)((AbstractBaseDTNode)((Object)this.siftNodes.get(index))));
        }

        public ExtDTNode<I> getHypNode(int index) {
            return (ExtDTNode)((Object)this.hypNodes.get(index));
        }
    }

    protected static class ExtDTNode<I>
    extends TTTDTNodeDFA<I> {
        private ExtDTNode<I> prevUnlabeled;
        private ExtDTNode<I> nextUnlabeled;
        private int tempPrefix = -1;

        public ExtDTNode() {
        }

        public ExtDTNode(ExtDTNode<I> parent, Boolean parentOut) {
            super(parent, parentOut);
        }

        public void removeFromUnlabeledList() {
            this.prevUnlabeled.nextUnlabeled = this.nextUnlabeled;
            if (this.nextUnlabeled != null) {
                this.nextUnlabeled.prevUnlabeled = this.prevUnlabeled;
            }
        }

        protected ExtDTNode<I> createChild(Boolean outcome, TTTState<I, Boolean> data) {
            return new ExtDTNode<I>(this, outcome);
        }

        public boolean hasUnlabeled() {
            return this.nextUnlabeled != null;
        }

        public void addUnlabeled(ExtDTNode<I> node) {
            node.nextUnlabeled = this.nextUnlabeled;
            if (this.nextUnlabeled != null) {
                this.nextUnlabeled.prevUnlabeled = node;
            }
            node.prevUnlabeled = this;
            this.nextUnlabeled = node;
        }

        public Iterable<ExtDTNode<I>> unlabeled() {
            return this::unlabeledIterator;
        }

        public Iterator<ExtDTNode<I>> unlabeledIterator() {
            return new UnlabeledIterator(this);
        }

        private static class UnlabeledIterator<I>
        extends AbstractSimplifiedIterator<ExtDTNode<I>> {
            private ExtDTNode<I> curr;

            UnlabeledIterator(ExtDTNode<I> curr) {
                this.curr = curr;
            }

            protected boolean calculateNext() {
                this.curr = ((ExtDTNode)this.curr).nextUnlabeled;
                if (this.curr == null) {
                    return false;
                }
                this.nextValue = this.curr;
                return true;
            }
        }
    }
}

