/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.ttt.base;

import de.learnlib.AccessSequenceProvider;
import de.learnlib.algorithm.ttt.base.AbstractBaseDTNode;
import de.learnlib.algorithm.ttt.base.TTTState;
import de.learnlib.datastructure.list.AbstractIntrusiveListEntryImpl;
import de.learnlib.datastructure.list.IntrusiveListEntry;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TTTTransition<I, D>
extends AbstractIntrusiveListEntryImpl<TTTTransition<I, D>>
implements AccessSequenceProvider<I> {
    private final TTTState<I, D> source;
    private final I input;
    AbstractBaseDTNode<I, D> nonTreeTarget;
    private TTTState<I, D> treeTarget;

    public TTTTransition(TTTState<I, D> source, I input) {
        this.source = source;
        this.input = input;
    }

    public TTTState<I, D> getTreeTarget() {
        assert (this.isTree());
        return this.treeTarget;
    }

    public boolean isTree() {
        return this.treeTarget != null;
    }

    public AbstractBaseDTNode<I, D> getNonTreeTarget() {
        assert (!this.isTree());
        return this.nonTreeTarget;
    }

    void setNonTreeTarget(AbstractBaseDTNode<I, D> nonTreeTarget) {
        this.nonTreeTarget = nonTreeTarget;
        nonTreeTarget.getIncoming().add((IntrusiveListEntry)this);
    }

    public AbstractBaseDTNode<I, D> getDTTarget() {
        if (this.treeTarget != null) {
            return this.treeTarget.dtLeaf;
        }
        return this.nonTreeTarget;
    }

    public TTTState<I, D> getTarget() {
        if (this.treeTarget != null) {
            return this.treeTarget;
        }
        assert (this.nonTreeTarget.isLeaf()) : "transition target is not a leaf, but is a " + (this.nonTreeTarget.isTemp() ? "temp" : "non-temp") + " node with discriminator: " + this.nonTreeTarget.getDiscriminator();
        assert (this.nonTreeTarget.getData() != null);
        return (TTTState)this.nonTreeTarget.getData();
    }

    public TTTState<I, D> getSource() {
        return this.source;
    }

    public I getInput() {
        return this.input;
    }

    protected @Nullable Object getProperty() {
        return null;
    }

    public Word<I> getAccessSequence() {
        WordBuilder wb = new WordBuilder();
        TTTTransition<I, D> curr = this;
        while (curr != null) {
            wb.add(curr.input);
            curr = curr.source.getParentTransition();
        }
        return wb.reverse().toWord();
    }

    void makeTree(TTTState<I, D> treeTarget) {
        this.removeFromList();
        this.treeTarget = treeTarget;
        this.nonTreeTarget = null;
    }

    public TTTTransition<I, D> getElement() {
        return this;
    }
}

