/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.ttt.base;

import de.learnlib.Resumable;
import de.learnlib.acex.AcexAnalyzer;
import de.learnlib.acex.AcexAnalyzers;
import de.learnlib.acex.OutInconsPrefixTransformAcex;
import de.learnlib.algorithm.LearningAlgorithm;
import de.learnlib.algorithm.ttt.base.AbstractBaseDTNode;
import de.learnlib.algorithm.ttt.base.AbstractTTTHypothesis;
import de.learnlib.algorithm.ttt.base.BaseTTTDiscriminationTree;
import de.learnlib.algorithm.ttt.base.HypothesisChangedException;
import de.learnlib.algorithm.ttt.base.OutputInconsistency;
import de.learnlib.algorithm.ttt.base.TTTLearnerState;
import de.learnlib.algorithm.ttt.base.TTTState;
import de.learnlib.algorithm.ttt.base.TTTTransition;
import de.learnlib.datastructure.discriminationtree.SplitData;
import de.learnlib.datastructure.discriminationtree.model.AbstractDTNode;
import de.learnlib.datastructure.list.IntrusiveList;
import de.learnlib.datastructure.list.IntrusiveListEntry;
import de.learnlib.logging.Category;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.DefaultQuery;
import de.learnlib.query.Query;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.SupportsGrowingAlphabet;
import net.automatalib.common.smartcollection.ElementReference;
import net.automatalib.common.smartcollection.UnorderedCollection;
import net.automatalib.common.util.collection.CollectionUtil;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTTTLearner<A, I, D>
implements LearningAlgorithm<A, I, D>,
SupportsGrowingAlphabet<I>,
Resumable<TTTLearnerState<I, D>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTTTLearner.class);
    protected final Alphabet<I> alphabet;
    protected final MembershipOracle<I, D> oracle;
    protected final AcexAnalyzer analyzer;
    protected final IntrusiveList<TTTTransition<I, D>> openTransitions = new IntrusiveList();
    protected final IntrusiveList<AbstractBaseDTNode<I, D>> blockList = new IntrusiveList();
    protected AbstractTTTHypothesis<?, I, D, ?> hypothesis;
    protected BaseTTTDiscriminationTree<I, D> dtree;

    protected AbstractTTTLearner(Alphabet<I> alphabet, MembershipOracle<I, D> oracle, AbstractTTTHypothesis<?, I, D, ?> hypothesis, BaseTTTDiscriminationTree<I, D> dtree, AcexAnalyzer analyzer) {
        this.alphabet = alphabet;
        this.hypothesis = hypothesis;
        this.oracle = oracle;
        this.dtree = dtree;
        this.analyzer = analyzer;
    }

    private static <I, D> void markAndPropagate(AbstractBaseDTNode<I, D> node, D label) {
        for (AbstractBaseDTNode curr = node; curr != null && curr.getSplitData() != null; curr = (AbstractBaseDTNode)curr.getParent()) {
            if (curr.getSplitData().mark(label)) continue;
            return;
        }
    }

    private static <I, D> void moveIncoming(AbstractBaseDTNode<I, D> newNode, AbstractBaseDTNode<I, D> oldNode, D label) {
        newNode.getIncoming().concat((IntrusiveList)oldNode.getSplitData().getIncoming(label));
    }

    protected static <I, D> void link(AbstractBaseDTNode<I, D> dtNode, TTTState<I, D> state) {
        assert (dtNode.isLeaf());
        dtNode.setData(state);
        state.dtLeaf = dtNode;
    }

    public void startLearning() {
        if (this.hypothesis.isInitialized()) {
            throw new IllegalStateException();
        }
        Object init = this.hypothesis.initialize();
        AbstractBaseDTNode<I, D> initNode = this.dtree.sift(((TTTState)init).getAccessSequence(), false);
        AbstractTTTLearner.link(initNode, init);
        this.initializeState((TTTState<I, D>)init);
        this.closeTransitions();
    }

    public boolean refineHypothesis(DefaultQuery<I, D> ceQuery) {
        if (!this.refineHypothesisSingle(ceQuery)) {
            return false;
        }
        while (this.refineHypothesisSingle(ceQuery)) {
        }
        return true;
    }

    protected void initializeState(TTTState<I, D> state) {
        TTTTransition<Object, D> head = null;
        for (int i = 0; i < this.alphabet.size(); ++i) {
            Object sym = this.alphabet.getSymbol(i);
            TTTTransition<Object, D> trans = this.createTransition(state, sym);
            trans.setNonTreeTarget((AbstractBaseDTNode)this.dtree.getRoot());
            state.setTransition(i, trans);
            this.openTransitions.add(trans);
            head = trans;
        }
        this.initTransitions(head, this.alphabet.size());
    }

    protected TTTTransition<I, D> createTransition(TTTState<I, D> state, I sym) {
        return new TTTTransition<I, D>(state, sym);
    }

    protected void initTransitions(TTTTransition<I, D> head, int num) {
    }

    protected boolean refineHypothesisSingle(DefaultQuery<I, D> ceQuery) {
        TTTState<I, D> state = this.getAnyState((Iterable<? extends I>)ceQuery.getPrefix());
        D out = this.computeHypothesisOutput(state, ceQuery.getSuffix());
        if (Objects.equals(out, ceQuery.getOutput())) {
            return false;
        }
        OutputInconsistency<I, Object> outIncons = new OutputInconsistency<I, Object>(state, ceQuery.getSuffix(), ceQuery.getOutput());
        do {
            this.splitState(outIncons);
            do {
                this.closeTransitions();
            } while (this.finalizeAny());
        } while ((outIncons = this.findOutputInconsistency()) != null);
        assert (this.allNodesFinal());
        return true;
    }

    private void splitState(TTTTransition<I, D> transition, Word<I> tempDiscriminator, D oldOut, D newOut) {
        assert (!transition.isTree());
        AbstractBaseDTNode<I, D> dtNode = transition.getNonTreeTarget();
        assert (dtNode.isLeaf());
        TTTState oldState = (TTTState)dtNode.getData();
        assert (oldState != null);
        TTTState<I, D> newState = this.makeTree(transition);
        AbstractDTNode.SplitResult children = dtNode.split(tempDiscriminator, oldOut, newOut);
        dtNode.setTemp(true);
        AbstractTTTLearner.link((AbstractBaseDTNode)children.nodeOld, oldState);
        AbstractTTTLearner.link((AbstractBaseDTNode)children.nodeNew, newState);
        if (dtNode.getParent() == null || !((AbstractBaseDTNode)dtNode.getParent()).isTemp()) {
            this.blockList.add(dtNode);
        }
    }

    private void splitState(OutputInconsistency<I, D> outIncons) {
        OutInconsPrefixTransformAcex<I, D> acex = this.deriveAcex(outIncons);
        try {
            int breakpoint = this.analyzer.analyzeAbstractCounterexample(acex);
            assert (!acex.testEffects(breakpoint, breakpoint + 1));
            Word suffix = outIncons.suffix;
            TTTState predState = this.getDeterministicState(outIncons.srcState, suffix.prefix(breakpoint));
            TTTState succState = this.getDeterministicState(outIncons.srcState, suffix.prefix(breakpoint + 1));
            assert (this.getDeterministicState(predState, Word.fromLetter((Object)suffix.getSymbol(breakpoint))) == succState);
            Object sym = suffix.getSymbol(breakpoint);
            Word splitSuffix = suffix.subWord(breakpoint + 1);
            TTTTransition trans = predState.getTransition(this.alphabet.getSymbolIndex(sym));
            assert (!trans.isTree());
            Object oldOut = acex.effect(breakpoint + 1);
            Object newOut = this.succEffect(acex.effect(breakpoint));
            this.splitState(trans, splitSuffix, oldOut, newOut);
        }
        catch (HypothesisChangedException hypothesisChangedException) {
            // empty catch block
        }
    }

    protected OutInconsPrefixTransformAcex<I, D> deriveAcex(OutputInconsistency<I, D> outIncons) {
        TTTState source = outIncons.srcState;
        Word suffix = outIncons.suffix;
        OutInconsPrefixTransformAcex acex = new OutInconsPrefixTransformAcex(suffix, this.oracle, w -> this.getDeterministicState(source, (Word<I>)w).getAccessSequence());
        acex.setEffect(0, outIncons.targetOut);
        return acex;
    }

    protected abstract D succEffect(D var1);

    protected boolean finalizeAny() {
        GlobalSplitter<I, D> splitter = this.findSplitterGlobal();
        if (splitter != null) {
            this.finalizeDiscriminator(splitter.blockRoot, splitter.localSplitter);
            return true;
        }
        return false;
    }

    protected TTTState<I, D> getDeterministicState(TTTState<I, D> start, Word<I> word) {
        TTTState<I, D> lastSingleton = start;
        int lastSingletonIndex = 0;
        Set<TTTState<I, D>> states = Collections.singleton(start);
        int i = 1;
        for (Object sym : word) {
            Set<TTTState<I, D>> nextStates = this.getNondetSuccessors(states, sym);
            if (nextStates.size() == 1) {
                lastSingleton = nextStates.iterator().next();
                lastSingletonIndex = i;
            }
            states = nextStates;
            ++i;
        }
        if (lastSingletonIndex == word.length()) {
            return lastSingleton;
        }
        TTTState<I, D> curr = lastSingleton;
        for (Object sym : word.subWord(lastSingletonIndex)) {
            TTTTransition<I, D> trans = curr.getTransition(this.alphabet.getSymbolIndex(sym));
            curr = this.requireSuccessor(trans);
        }
        return curr;
    }

    protected Set<TTTState<I, D>> getNondetSuccessors(Collection<? extends TTTState<I, D>> states, I sym) {
        HashSet<TTTState<I, D>> result = new HashSet<TTTState<I, D>>();
        int symIdx = this.alphabet.getSymbolIndex(sym);
        for (TTTState<I, D> state : states) {
            TTTTransition<I, D> trans = state.getTransition(symIdx);
            if (trans.isTree()) {
                result.add(trans.getTreeTarget());
                continue;
            }
            AbstractBaseDTNode<I, D> tgtNode = trans.getNonTreeTarget();
            CollectionUtil.add(result, tgtNode.subtreeStatesIterator());
        }
        return result;
    }

    protected TTTState<I, D> getAnySuccessor(TTTState<I, D> state, I sym) {
        int symIdx = this.alphabet.getSymbolIndex(sym);
        TTTTransition<I, D> trans = state.getTransition(symIdx);
        if (trans.isTree()) {
            return trans.getTreeTarget();
        }
        return trans.getNonTreeTarget().subtreeStatesIterator().next();
    }

    protected TTTState<I, D> getAnySuccessor(TTTState<I, D> state, Iterable<? extends I> suffix) {
        TTTState<I, D> curr = state;
        for (I sym : suffix) {
            curr = this.getAnySuccessor(curr, sym);
        }
        return curr;
    }

    private TTTState<I, D> requireSuccessor(TTTTransition<I, D> trans) {
        if (trans.isTree()) {
            return trans.getTreeTarget();
        }
        AbstractBaseDTNode<I, D> newTgtNode = this.updateDTTarget(trans, true);
        if (newTgtNode.getData() == null) {
            this.makeTree(trans);
            this.closeTransitions();
            throw new HypothesisChangedException();
        }
        return (TTTState)newTgtNode.getData();
    }

    private @Nullable GlobalSplitter<I, D> findSplitterGlobal() {
        boolean optimizeGlobal = true;
        AbstractBaseDTNode bestBlockRoot = null;
        Splitter<I, D> bestSplitter = null;
        for (AbstractBaseDTNode blockRoot : this.blockList) {
            Splitter<I, D> splitter = this.findSplitter(blockRoot);
            if (splitter == null) continue;
            if (bestSplitter == null || splitter.getDiscriminatorLength() < bestSplitter.getDiscriminatorLength()) {
                bestSplitter = splitter;
                bestBlockRoot = blockRoot;
            }
            if (optimizeGlobal) continue;
            break;
        }
        if (bestSplitter == null) {
            return null;
        }
        return new GlobalSplitter(bestBlockRoot, bestSplitter);
    }

    private @Nullable Splitter<I, D> findSplitter(AbstractBaseDTNode<I, D> blockRoot) {
        int alphabetSize = this.alphabet.size();
        @Nullable Object[] properties = new Object[alphabetSize];
        AbstractBaseDTNode[] lcas = new AbstractBaseDTNode[alphabetSize];
        boolean first = true;
        for (TTTState<I, D> state : blockRoot.subtreeStates()) {
            for (int i = 0; i < alphabetSize; ++i) {
                TTTTransition<I, D> trans = state.getTransition(i);
                if (first) {
                    properties[i] = trans.getProperty();
                    lcas[i] = trans.getDTTarget();
                    continue;
                }
                if (!Objects.equals(properties[i], trans.getProperty())) {
                    return new Splitter(i);
                }
                lcas[i] = (AbstractBaseDTNode)this.dtree.leastCommonAncestor((AbstractDTNode)lcas[i], (AbstractDTNode)trans.getDTTarget());
            }
            first = false;
        }
        int shortestLen = Integer.MAX_VALUE;
        AbstractBaseDTNode shortestLca = null;
        int shortestLcaSym = -1;
        for (int i = 0; i < alphabetSize; ++i) {
            AbstractBaseDTNode lca = lcas[i];
            if (lca.isTemp() || lca.isLeaf()) continue;
            int lcaLen = ((Word)lca.getDiscriminator()).length();
            if (shortestLca != null && lcaLen >= shortestLen) continue;
            shortestLca = lca;
            shortestLen = lcaLen;
            shortestLcaSym = i;
        }
        if (shortestLca != null) {
            return new Splitter(shortestLcaSym, shortestLca);
        }
        return null;
    }

    private TTTState<I, D> createState(TTTTransition<I, D> transition) {
        return this.hypothesis.createState(transition);
    }

    protected TTTState<I, D> getAnyTarget(TTTTransition<I, D> trans) {
        if (trans.isTree()) {
            return trans.getTreeTarget();
        }
        return trans.getNonTreeTarget().anySubtreeState();
    }

    private TTTState<I, D> getAnyState(Iterable<? extends I> suffix) {
        return this.getAnySuccessor((TTTState<I, D>)this.hypothesis.getInitialState(), suffix);
    }

    protected OutputInconsistency<I, D> findOutputInconsistency() {
        OutputInconsistency best = null;
        for (TTTState state : this.hypothesis.getStates()) {
            AbstractBaseDTNode node = state.getDTLeaf();
            while (!node.isRoot()) {
                D hypOut;
                Object expectedOut = node.getParentOutcome();
                node = (AbstractBaseDTNode)node.getParent();
                Word suffix = (Word)node.getDiscriminator();
                if (best != null && suffix.length() >= best.suffix.length() || Objects.equals(hypOut = this.computeHypothesisOutput(state, suffix), expectedOut)) continue;
                best = new OutputInconsistency(state, suffix, expectedOut);
            }
        }
        return best;
    }

    private void finalizeDiscriminator(AbstractBaseDTNode<I, D> blockRoot, Splitter<I, D> splitter) {
        assert (blockRoot.isBlockRoot());
        Word succDiscr = splitter.getDiscriminator().prepend(this.alphabet.getSymbol(splitter.symbolIdx));
        if (!((Word)blockRoot.getDiscriminator()).equals((Object)succDiscr)) {
            Word<I> finalDiscriminator = this.prepareSplit(blockRoot, splitter);
            Map<D, AbstractBaseDTNode<I, D>> repChildren = this.createMap();
            for (Object label : blockRoot.getSplitData().getLabels()) {
                repChildren.put(label, this.extractSubtree(blockRoot, label));
            }
            blockRoot.replaceChildren(repChildren);
            blockRoot.setDiscriminator(finalDiscriminator);
        }
        this.declareFinal(blockRoot);
    }

    protected boolean allNodesFinal() {
        Iterator it = ((AbstractBaseDTNode)this.dtree.getRoot()).subtreeNodesIterator();
        while (it.hasNext()) {
            AbstractBaseDTNode node = it.next();
            assert (!node.isTemp()) : "Final node with discriminator " + node.getDiscriminator();
        }
        return true;
    }

    protected void declareFinal(AbstractBaseDTNode<I, D> blockRoot) {
        blockRoot.setTemp(false);
        blockRoot.setSplitData(null);
        blockRoot.removeFromList();
        for (AbstractBaseDTNode subtree : blockRoot.getChildren()) {
            assert (subtree.getSplitData() == null);
            blockRoot.setChild(subtree.getParentOutcome(), subtree);
            if (!subtree.isInner()) continue;
            this.blockList.add((IntrusiveListEntry)subtree);
        }
        this.openTransitions.concat(blockRoot.getIncoming());
    }

    private Word<I> prepareSplit(AbstractBaseDTNode<I, D> node, Splitter<I, D> splitter) {
        int symbolIdx = splitter.symbolIdx;
        Object symbol = this.alphabet.getSymbol(symbolIdx);
        Word discriminator = splitter.getDiscriminator().prepend(symbol);
        ArrayDeque<AbstractBaseDTNode> dfsStack = new ArrayDeque<AbstractBaseDTNode>();
        ArrayList queries = new ArrayList();
        AbstractBaseDTNode succSeparator = splitter.succSeparator;
        dfsStack.push(node);
        assert (node.getSplitData() == null);
        while (!dfsStack.isEmpty()) {
            TTTTransition trans2;
            AbstractBaseDTNode curr = (AbstractBaseDTNode)((Object)dfsStack.pop());
            assert (curr.getSplitData() == null);
            curr.setSplitData(new SplitData(IntrusiveList::new));
            for (TTTTransition trans2 : curr.getIncoming()) {
                queries.add(new SplitQuery(trans2, discriminator));
            }
            if (!queries.isEmpty()) {
                this.oracle.processQueries(queries);
                for (SplitQuery query : queries) {
                    ((IntrusiveList)curr.getSplitData().getIncoming(query.output)).add((IntrusiveListEntry)query.transition);
                    AbstractTTTLearner.markAndPropagate(curr, query.output);
                }
                queries.clear();
            }
            if (curr.isInner()) {
                for (AbstractBaseDTNode child : curr.getChildren()) {
                    dfsStack.push(child);
                }
                continue;
            }
            TTTState state = (TTTState)curr.getData();
            assert (state != null);
            trans2 = state.getTransition(symbolIdx);
            Object outcome = this.predictSuccOutcome(trans2, succSeparator);
            assert (outcome != null);
            curr.getSplitData().setStateLabel(outcome);
            AbstractTTTLearner.markAndPropagate(curr, outcome);
        }
        return discriminator;
    }

    protected abstract D predictSuccOutcome(TTTTransition<I, D> var1, AbstractBaseDTNode<I, D> var2);

    private AbstractBaseDTNode<I, D> extractSubtree(AbstractBaseDTNode<I, D> root, D label) {
        assert (root.getSplitData() != null);
        assert (root.getSplitData().isMarked(label));
        ArrayDeque stack = new ArrayDeque();
        AbstractBaseDTNode<I, D> firstExtracted = this.createNewNode(root, label);
        stack.push(new ExtractRecord<I, D>(root, firstExtracted));
        while (!stack.isEmpty()) {
            ExtractRecord curr = (ExtractRecord)stack.pop();
            AbstractBaseDTNode original = curr.original;
            AbstractBaseDTNode extracted = curr.extracted;
            AbstractTTTLearner.moveIncoming(extracted, original, label);
            if (original.isLeaf()) {
                if (Objects.equals(original.getSplitData().getStateLabel(), label)) {
                    AbstractTTTLearner.link(extracted, (TTTState)original.getData());
                } else {
                    this.createNewState(extracted);
                }
                extracted.updateIncoming();
            } else {
                ArrayList<AbstractBaseDTNode> markedChildren = new ArrayList<AbstractBaseDTNode>();
                for (AbstractBaseDTNode child : original.getChildren()) {
                    if (!child.getSplitData().isMarked(label)) continue;
                    markedChildren.add(child);
                }
                if (markedChildren.size() > 1) {
                    Map childMap = this.createMap();
                    for (AbstractBaseDTNode c : markedChildren) {
                        Object childLabel = c.getParentOutcome();
                        AbstractBaseDTNode extractedChild = this.createNewNode(extracted, childLabel);
                        childMap.put(childLabel, extractedChild);
                        stack.push(new ExtractRecord(c, extractedChild));
                    }
                    extracted.setDiscriminator((Word)original.getDiscriminator());
                    extracted.replaceChildren(childMap);
                    extracted.updateIncoming();
                    extracted.setTemp(true);
                } else if (markedChildren.size() == 1) {
                    stack.push(new ExtractRecord((AbstractBaseDTNode)((Object)markedChildren.get(0)), extracted));
                } else {
                    this.createNewState(extracted);
                    extracted.updateIncoming();
                }
            }
            assert (extracted.getSplitData() == null);
        }
        return firstExtracted;
    }

    protected <V> Map<D, V> createMap() {
        return new HashMap();
    }

    private void createNewState(AbstractBaseDTNode<I, D> newNode) {
        TTTTransition newTreeTrans = (TTTTransition)newNode.getIncoming().choose();
        assert (newTreeTrans != null);
        TTTState<I, D> newState = this.createState(newTreeTrans);
        AbstractTTTLearner.link(newNode, newState);
        this.initializeState(newState);
    }

    protected abstract D computeHypothesisOutput(TTTState<I, D> var1, Word<I> var2);

    public AbstractTTTHypothesis<?, I, D, ?> getHypothesisDS() {
        return this.hypothesis;
    }

    protected void closeTransitions() {
        UnorderedCollection newStateNodes = new UnorderedCollection();
        do {
            newStateNodes.addAll(this.closeTransitions(this.openTransitions, false));
            if (newStateNodes.isEmpty()) continue;
            this.addNewStates(newStateNodes);
        } while (!this.openTransitions.isEmpty());
    }

    private List<AbstractBaseDTNode<I, D>> closeTransitions(IntrusiveList<TTTTransition<I, D>> transList, boolean hard) {
        TTTTransition t;
        ArrayList<TTTTransition<I, D>> transToSift = new ArrayList<TTTTransition<I, D>>(transList.size());
        while ((t = (TTTTransition)transList.poll()) != null) {
            if (t.isTree()) continue;
            transToSift.add(t);
        }
        if (transToSift.isEmpty()) {
            return Collections.emptyList();
        }
        Iterator<AbstractBaseDTNode<I, D>> leavesIter = this.updateDTTargets(transToSift, hard).iterator();
        ArrayList<AbstractBaseDTNode<I, D>> result = new ArrayList<AbstractBaseDTNode<I, D>>(transToSift.size());
        for (TTTTransition tTTTransition : transToSift) {
            AbstractBaseDTNode<I, D> node = leavesIter.next();
            if (!node.isLeaf() || node.getData() != null || tTTTransition.getNext() != null) continue;
            result.add(node);
        }
        assert (!leavesIter.hasNext());
        return result;
    }

    private void addNewStates(UnorderedCollection<AbstractBaseDTNode<I, D>> newStateNodes) {
        AbstractBaseDTNode minTransNode = null;
        TTTTransition minTrans = null;
        int minAsLen = Integer.MAX_VALUE;
        ElementReference minTransNodeRef = null;
        for (ElementReference ref : newStateNodes.references()) {
            AbstractBaseDTNode newStateNode = (AbstractBaseDTNode)((Object)newStateNodes.get(ref));
            for (TTTTransition trans : newStateNode.getIncoming()) {
                Word as = trans.getAccessSequence();
                int asLen = as.length();
                if (asLen >= minAsLen) continue;
                minTransNode = newStateNode;
                minTrans = trans;
                minAsLen = asLen;
                minTransNodeRef = ref;
            }
        }
        assert (minTransNode != null);
        newStateNodes.remove(minTransNodeRef);
        TTTState<I, D> state = this.makeTree(minTrans);
        AbstractTTTLearner.link(minTransNode, state);
        this.initializeState(state);
    }

    protected TTTState<I, D> makeTree(TTTTransition<I, D> trans) {
        assert (!trans.isTree());
        AbstractBaseDTNode node = trans.nonTreeTarget;
        assert (node.isLeaf());
        TTTState<I, D> state = this.createState(trans);
        trans.removeFromList();
        AbstractTTTLearner.link(node, state);
        this.initializeState(state);
        return state;
    }

    private AbstractBaseDTNode<I, D> updateDTTarget(TTTTransition<I, D> transition, boolean hard) {
        if (transition.isTree()) {
            return transition.getTreeTarget().dtLeaf;
        }
        AbstractBaseDTNode<I, D> dt = transition.getNonTreeTarget();
        dt = this.dtree.sift(dt, transition.getAccessSequence(), hard);
        transition.setNonTreeTarget(dt);
        return dt;
    }

    private List<AbstractBaseDTNode<I, D>> updateDTTargets(List<TTTTransition<I, D>> transitions, boolean hard) {
        ArrayList nodes = new ArrayList(transitions.size());
        ArrayList prefixes = new ArrayList(transitions.size());
        for (TTTTransition<I, D> t : transitions) {
            if (t.isTree()) continue;
            AbstractBaseDTNode<I, D> dt = t.getNonTreeTarget();
            nodes.add(dt);
            prefixes.add(t.getAccessSequence());
        }
        Iterator<AbstractBaseDTNode<I, D>> leavesIter = this.dtree.sift(nodes, prefixes, hard).iterator();
        ArrayList<AbstractBaseDTNode<I, D>> result = new ArrayList<AbstractBaseDTNode<I, D>>(transitions.size());
        for (TTTTransition<I, D> t : transitions) {
            if (t.isTree()) {
                result.add(t.getTreeTarget().dtLeaf);
                continue;
            }
            AbstractBaseDTNode<I, D> leaf = leavesIter.next();
            t.setNonTreeTarget(leaf);
            result.add(leaf);
        }
        assert (!leavesIter.hasNext());
        return result;
    }

    public BaseTTTDiscriminationTree<I, D> getDiscriminationTree() {
        return this.dtree;
    }

    public void addAlphabetSymbol(I symbol) {
        if (!this.alphabet.containsSymbol(symbol)) {
            this.alphabet.asGrowingAlphabetOrThrowException().addSymbol(symbol);
        }
        this.hypothesis.addAlphabetSymbol(symbol);
        if (this.hypothesis.getInitialState() != null && this.hypothesis.getState((Iterable)Word.fromLetter(symbol)) == null) {
            int newSymbolIdx = this.alphabet.getSymbolIndex(symbol);
            TTTTransition<I, D> head = null;
            for (TTTState s : this.hypothesis.getStates()) {
                TTTTransition<I, D> trans = this.createTransition(s, symbol);
                trans.setNonTreeTarget((AbstractBaseDTNode)this.dtree.getRoot());
                s.setTransition(newSymbolIdx, trans);
                this.openTransitions.add(trans);
                head = trans;
            }
            this.initTransitions(head, this.hypothesis.size());
            this.closeTransitions();
        }
    }

    protected abstract AbstractBaseDTNode<I, D> createNewNode(AbstractBaseDTNode<I, D> var1, D var2);

    public TTTLearnerState<I, D> suspend() {
        return new TTTLearnerState<I, D>(this.hypothesis, this.dtree);
    }

    public void resume(TTTLearnerState<I, D> state) {
        this.hypothesis = state.getHypothesis();
        this.dtree = state.getDiscriminationTree();
        this.dtree.setOracle(this.oracle);
        Alphabet<I> oldAlphabet = this.hypothesis.getInputAlphabet();
        if (!oldAlphabet.equals(this.alphabet)) {
            LOGGER.warn(Category.DATASTRUCTURE, "The current alphabet '{}' differs from the resumed alphabet '{}'. Future behavior may be inconsistent", this.alphabet, oldAlphabet);
        }
    }

    private static final class SplitQuery<I, D>
    extends Query<I, D> {
        private final TTTTransition<I, D> transition;
        private final Word<I> discriminator;
        private D output;

        SplitQuery(TTTTransition<I, D> transition, Word<I> discriminator) {
            this.transition = transition;
            this.discriminator = discriminator;
        }

        public void answer(D output) {
            this.output = output;
        }

        public Word<I> getPrefix() {
            return this.transition.getAccessSequence();
        }

        public Word<I> getSuffix() {
            return this.discriminator;
        }
    }

    private static final class ExtractRecord<I, D> {
        public final AbstractBaseDTNode<I, D> original;
        public final AbstractBaseDTNode<I, D> extracted;

        ExtractRecord(AbstractBaseDTNode<I, D> original, AbstractBaseDTNode<I, D> extracted) {
            this.original = original;
            this.extracted = extracted;
        }
    }

    private static final class GlobalSplitter<I, D> {
        public final Splitter<I, D> localSplitter;
        public final AbstractBaseDTNode<I, D> blockRoot;

        GlobalSplitter(AbstractBaseDTNode<I, D> blockRoot, Splitter<I, D> localSplitter) {
            this.blockRoot = blockRoot;
            this.localSplitter = localSplitter;
        }
    }

    public static final class Splitter<I, D> {
        public final int symbolIdx;
        public final AbstractBaseDTNode<I, D> succSeparator;

        public Splitter(int symbolIdx) {
            this.symbolIdx = symbolIdx;
            this.succSeparator = null;
        }

        public Splitter(int symbolIdx, AbstractBaseDTNode<I, D> succSeparator) {
            assert (!succSeparator.isTemp() && succSeparator.isInner());
            this.symbolIdx = symbolIdx;
            this.succSeparator = succSeparator;
        }

        public Word<I> getDiscriminator() {
            return this.succSeparator != null ? (Word)this.succSeparator.getDiscriminator() : Word.epsilon();
        }

        public int getDiscriminatorLength() {
            return this.succSeparator != null ? ((Word)this.succSeparator.getDiscriminator()).length() : 0;
        }
    }

    public static final class BuilderDefaults {
        private BuilderDefaults() {
        }

        public static AcexAnalyzer analyzer() {
            return AcexAnalyzers.BINARY_SEARCH_BWD;
        }
    }
}

