/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.ttt.base;

import de.learnlib.algorithm.ttt.base.TTTState;
import de.learnlib.algorithm.ttt.base.TTTTransition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.SupportsGrowingAlphabet;
import net.automatalib.automaton.DeterministicAutomaton;
import net.automatalib.automaton.FiniteAlphabetAutomaton;
import net.automatalib.automaton.concept.StateIDs;
import net.automatalib.graph.Graph;
import net.automatalib.visualization.DefaultVisualizationHelper;
import net.automatalib.visualization.VisualizationHelper;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractTTTHypothesis<S extends TTTState<I, D>, I, D, T>
implements DeterministicAutomaton<S, I, T>,
FiniteAlphabetAutomaton<S, I, T>,
DeterministicAutomaton.FullIntAbstraction<T>,
StateIDs<S>,
SupportsGrowingAlphabet<I> {
    protected final List<S> states = new ArrayList<S>();
    private final Alphabet<I> alphabet;
    private int alphabetSize;
    private S initialState;

    public AbstractTTTHypothesis(Alphabet<I> alphabet) {
        this.alphabet = alphabet;
        this.alphabetSize = this.alphabet.size();
    }

    public S getInitialState() {
        return this.initialState;
    }

    public T getTransition(int stateId, int symIdx) {
        TTTState state = (TTTState)this.states.get(stateId);
        TTTTransition<I, D> trans = this.getInternalTransition(state, symIdx);
        return this.mapTransition(trans);
    }

    public @Nullable T getTransition(S state, I input) {
        TTTTransition<I, D> trans = this.getInternalTransition((TTTState<I, D>)state, input);
        return trans == null ? null : (T)this.mapTransition(trans);
    }

    public TTTTransition<I, D> getInternalTransition(TTTState<I, D> state, I input) {
        int inputIdx = this.alphabet.getSymbolIndex(input);
        return this.getInternalTransition(state, inputIdx);
    }

    public TTTTransition<I, D> getInternalTransition(TTTState<I, D> state, int input) {
        return state.getTransition(input);
    }

    protected abstract T mapTransition(TTTTransition<I, D> var1);

    public S initialize() {
        assert (!this.isInitialized());
        this.initialState = this.createState(null);
        return this.initialState;
    }

    public boolean isInitialized() {
        return this.initialState != null;
    }

    public S createState(TTTTransition<I, D> parent) {
        S state = this.newState(this.alphabet.size(), parent, this.states.size());
        this.states.add(state);
        if (parent != null) {
            parent.makeTree((TTTState<I, D>)state);
        }
        return state;
    }

    protected abstract S newState(int var1, TTTTransition<I, D> var2, int var3);

    public Alphabet<I> getInputAlphabet() {
        return this.alphabet;
    }

    public GraphView graphView() {
        return new GraphView();
    }

    public int getIntInitialState() {
        return 0;
    }

    public int numInputs() {
        return this.alphabet.size();
    }

    public int getIntSuccessor(T trans) {
        return ((TTTState)this.getSuccessor(trans)).id;
    }

    public DeterministicAutomaton.FullIntAbstraction<T> fullIntAbstraction(Alphabet<I> alphabet) {
        if (alphabet == this.alphabet) {
            return this;
        }
        return super.fullIntAbstraction(alphabet);
    }

    public void addAlphabetSymbol(I symbol) {
        int newAlphabetSize;
        if (!this.alphabet.containsSymbol(symbol)) {
            this.alphabet.asGrowingAlphabetOrThrowException().addSymbol(symbol);
        }
        if (this.alphabetSize < (newAlphabetSize = this.alphabet.size())) {
            for (TTTState s : this.getStates()) {
                s.ensureInputCapacity(newAlphabetSize);
            }
            this.alphabetSize = newAlphabetSize;
        }
    }

    public Collection<S> getStates() {
        return Collections.unmodifiableList(this.states);
    }

    public int size() {
        return this.states.size();
    }

    public int getStateId(S state) {
        return ((TTTState)state).id;
    }

    public S getState(int id) {
        return (S)((TTTState)this.states.get(id));
    }

    public StateIDs<S> stateIDs() {
        return this;
    }

    public class GraphView
    implements Graph<TTTState<I, D>, TTTEdge<I, D>> {
        public Collection<TTTState<I, D>> getNodes() {
            return Collections.unmodifiableList(AbstractTTTHypothesis.this.states);
        }

        public Collection<TTTEdge<I, D>> getOutgoingEdges(TTTState<I, D> node) {
            ArrayList result = new ArrayList();
            for (TTTTransition trans : node.getTransitions()) {
                for (TTTState target : trans.getDTTarget().subtreeStates()) {
                    result.add(new TTTEdge(trans, target));
                }
            }
            return result;
        }

        public TTTState<I, D> getTarget(TTTEdge<I, D> edge) {
            return edge.target;
        }

        public VisualizationHelper<TTTState<I, D>, TTTEdge<I, D>> getVisualizationHelper() {
            return new DefaultVisualizationHelper<TTTState<I, D>, TTTEdge<I, D>>(){

                public boolean getEdgeProperties(TTTState<I, D> src, TTTEdge<I, D> edge, TTTState<I, D> tgt, Map<String, String> properties) {
                    super.getEdgeProperties(src, edge, tgt, properties);
                    properties.put("label", String.valueOf(edge.transition.getInput()));
                    if (edge.transition.isTree()) {
                        properties.put("style", "bold");
                    } else if (edge.transition.getDTTarget().isInner()) {
                        properties.put("style", "dotted");
                    }
                    return true;
                }
            };
        }
    }

    public static final class TTTEdge<I, D> {
        public final TTTTransition<I, D> transition;
        public final TTTState<I, D> target;

        public TTTEdge(TTTTransition<I, D> transition, TTTState<I, D> target) {
            this.transition = transition;
            this.target = target;
        }
    }
}

