/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.ttt.dfa;

import de.learnlib.algorithms.ttt.base.BaseTTTLearner;
import de.learnlib.algorithms.ttt.base.DTNode;
import de.learnlib.algorithms.ttt.base.TTTHypothesis;
import de.learnlib.algorithms.ttt.base.TTTState;
import de.learnlib.algorithms.ttt.base.TTTTransition;
import de.learnlib.algorithms.ttt.dfa.TTTHypothesisDFA;
import de.learnlib.algorithms.ttt.dfa.TTTStateDFA;
import de.learnlib.api.LearningAlgorithm;
import de.learnlib.api.MembershipOracle;
import de.learnlib.counterexamples.LocalSuffixFinder;
import java.util.Map;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.graphs.dot.EmptyDOTHelper;
import net.automatalib.graphs.dot.GraphDOTHelper;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;

public class TTTLearnerDFA<I>
extends BaseTTTLearner<DFA<?, I>, I, Boolean>
implements LearningAlgorithm.DFALearner<I> {
    public TTTLearnerDFA(Alphabet<I> alphabet, MembershipOracle<I, Boolean> oracle, LocalSuffixFinder<? super I, ? super Boolean> suffixFinder) {
        super(alphabet, oracle, new TTTHypothesisDFA<I>(alphabet), suffixFinder);
        this.split(this.dtree.getRoot(), Word.epsilon(), false, true);
    }

    public TTTHypothesisDFA<I> getHypothesisDS() {
        return (TTTHypothesisDFA)this.hypothesis;
    }

    public DFA<?, I> getHypothesisModel() {
        return (TTTHypothesisDFA)this.hypothesis;
    }

    @Override
    protected void initializeState(TTTState<I, Boolean> state) {
        super.initializeState(state);
        TTTStateDFA dfaState = (TTTStateDFA)state;
        dfaState.accepting = (Boolean)this.dtree.getRoot().subtreeLabel(dfaState.getDTLeaf());
    }

    @Override
    protected Boolean predictSuccOutcome(TTTTransition<I, Boolean> trans, DTNode<I, Boolean> succSeparator) {
        return succSeparator.subtreeLabel(trans.getDTTarget());
    }

    @Override
    protected Boolean computeHypothesisOutput(TTTState<I, Boolean> state, Iterable<? extends I> suffix) {
        TTTStateDFA endState = (TTTStateDFA)this.getState(state, suffix);
        return endState.accepting;
    }

    @Override
    public GraphDOTHelper<TTTState<I, Boolean>, TTTHypothesis.TTTEdge<I, Boolean>> getHypothesisDOTHelper() {
        return new EmptyDOTHelper<TTTState<I, Boolean>, TTTHypothesis.TTTEdge<I, Boolean>>(){

            public boolean getNodeProperties(TTTState<I, Boolean> node, Map<String, String> properties) {
                TTTStateDFA dfaState = (TTTStateDFA)node;
                if (dfaState.isAccepting()) {
                    properties.put("shape", "doublecircle");
                }
                return true;
            }
        };
    }
}

