/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.ttt.base;

import de.learnlib.algorithms.ttt.base.AccessSequenceProvider;
import de.learnlib.algorithms.ttt.base.DTNode;
import de.learnlib.algorithms.ttt.base.IncomingListElem;
import de.learnlib.algorithms.ttt.base.TTTState;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;

public class TTTTransition<I, D>
extends IncomingListElem<I, D>
implements AccessSequenceProvider<I> {
    private final TTTState<I, D> source;
    private final I input;
    private TTTState<I, D> treeTarget;
    DTNode<I, D> nonTreeTarget;
    protected IncomingListElem<I, D> prevIncoming;

    public TTTTransition(TTTState<I, D> source, I input) {
        this.source = source;
        this.input = input;
    }

    public boolean isTree() {
        return this.treeTarget != null;
    }

    public TTTState<I, D> getTreeTarget() {
        assert (this.isTree());
        return this.treeTarget;
    }

    public DTNode<I, D> getNonTreeTarget() {
        assert (!this.isTree());
        return this.nonTreeTarget;
    }

    public DTNode<I, D> getDTTarget() {
        if (this.treeTarget != null) {
            return this.treeTarget.dtLeaf;
        }
        return this.nonTreeTarget;
    }

    public TTTState<I, D> getTarget() {
        if (this.treeTarget != null) {
            return this.treeTarget;
        }
        return this.nonTreeTarget.state;
    }

    public TTTState<I, D> getSource() {
        return this.source;
    }

    public I getInput() {
        return this.input;
    }

    protected Object getProperty() {
        return null;
    }

    @Override
    public Word<I> getAccessSequence() {
        WordBuilder wb = new WordBuilder();
        TTTTransition curr = this;
        while (curr != null) {
            wb.add(curr.input);
            curr = curr.source.parentTransition;
        }
        return wb.reverse().toWord();
    }

    void makeTree(TTTState<I, D> treeTarget) {
        this.removeFromList();
        this.treeTarget = treeTarget;
        this.nonTreeTarget = null;
    }

    void setNonTreeTarget(DTNode<I, D> nonTreeTarget) {
        this.nonTreeTarget = nonTreeTarget;
        nonTreeTarget.getIncoming().insertIncoming(this);
    }

    void removeFromList() {
        if (this.prevIncoming != null) {
            this.prevIncoming.nextIncoming = this.nextIncoming;
        }
        if (this.nextIncoming != null) {
            this.nextIncoming.prevIncoming = this.prevIncoming;
        }
    }
}

