/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.ttt.base;

import de.learnlib.algorithms.ttt.base.IncomingList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SplitData<I, D> {
    private final Set<D> marks = new HashSet<D>();
    private final Map<D, IncomingList<I, D>> incomingTransitions = new HashMap<D, IncomingList<I, D>>();
    private D stateLabel;

    public boolean mark(D label) {
        return this.marks.add(label);
    }

    public Set<D> getLabels() {
        return this.marks;
    }

    public boolean hasStateLabel() {
        return this.stateLabel != null;
    }

    public void setStateLabel(D label) {
        assert (!this.hasStateLabel());
        this.stateLabel = label;
    }

    public D getStateLabel() {
        assert (this.hasStateLabel());
        return this.stateLabel;
    }

    public IncomingList<I, D> getIncoming(D label) {
        IncomingList<I, D> list = this.incomingTransitions.get(label);
        if (list == null) {
            list = new IncomingList();
            this.incomingTransitions.put(label, list);
        }
        return list;
    }

    public boolean isMarked(D label) {
        return this.marks.contains(label);
    }
}

