/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.ttt.base;

import de.learnlib.algorithms.ttt.base.IncomingListElem;
import de.learnlib.algorithms.ttt.base.TTTTransition;
import java.util.Iterator;

public class IncomingList<I, D>
extends IncomingListElem<I, D>
implements Iterable<TTTTransition<I, D>> {
    public void insertIncoming(TTTTransition<I, D> transition) {
        transition.removeFromList();
        transition.nextIncoming = this.nextIncoming;
        transition.prevIncoming = this;
        if (this.nextIncoming != null) {
            this.nextIncoming.prevIncoming = transition;
        }
        this.nextIncoming = transition;
    }

    public void insertAllIncoming(IncomingList<I, D> list) {
        this.insertAllIncoming(list.nextIncoming);
    }

    public void insertAllIncoming(TTTTransition<I, D> firstTransition) {
        if (firstTransition == null) {
            return;
        }
        if (this.nextIncoming == null) {
            this.nextIncoming = firstTransition;
            firstTransition.prevIncoming = this;
        } else {
            TTTTransition oldNext = this.nextIncoming;
            this.nextIncoming = firstTransition;
            firstTransition.prevIncoming = this;
            TTTTransition last = firstTransition;
            while (last.nextIncoming != null) {
                last = last.nextIncoming;
            }
            last.nextIncoming = oldNext;
            oldNext.prevIncoming = last;
        }
    }

    public TTTTransition<I, D> choose() {
        return this.nextIncoming;
    }

    @Override
    public Iterator<TTTTransition<I, D>> iterator() {
        return new ListIterator(this.nextIncoming);
    }

    private static final class ListIterator<I, D>
    implements Iterator<TTTTransition<I, D>> {
        private TTTTransition<I, D> cursor;

        public ListIterator(TTTTransition<I, D> start) {
            this.cursor = start;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != null;
        }

        @Override
        public TTTTransition<I, D> next() {
            TTTTransition<I, D> curr = this.cursor;
            this.cursor = this.cursor.nextIncoming;
            return curr;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

