/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.ttt.base;

import de.learnlib.algorithms.ttt.base.BlockListElem;
import de.learnlib.algorithms.ttt.base.DTNode;
import java.util.Iterator;

public class BlockList<I, D>
extends BlockListElem<I, D>
implements Iterable<DTNode<I, D>> {
    public void insertBlock(DTNode<I, D> blockRoot) {
        blockRoot.removeFromBlockList();
        blockRoot.nextBlock = this.nextBlock;
        if (this.nextBlock != null) {
            this.nextBlock.prevBlock = blockRoot;
        }
        blockRoot.prevBlock = this;
        this.nextBlock = blockRoot;
    }

    public DTNode<I, D> chooseBlock() {
        return this.nextBlock;
    }

    @Override
    public Iterator<DTNode<I, D>> iterator() {
        return new ListIterator(this.nextBlock);
    }

    public boolean isEmpty() {
        return this.nextBlock == null;
    }

    private static final class ListIterator<I, D>
    implements Iterator<DTNode<I, D>> {
        private DTNode<I, D> cursor;

        public ListIterator(DTNode<I, D> start) {
            this.cursor = start;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != null;
        }

        @Override
        public DTNode<I, D> next() {
            DTNode<I, D> current = this.cursor;
            this.cursor = this.cursor.nextBlock;
            return current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

