/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.ttt.base;

import de.learnlib.algorithms.ttt.base.AccessSequenceProvider;
import de.learnlib.algorithms.ttt.base.BlockList;
import de.learnlib.algorithms.ttt.base.DTNode;
import de.learnlib.algorithms.ttt.base.DiscriminationTree;
import de.learnlib.algorithms.ttt.base.SplitData;
import de.learnlib.algorithms.ttt.base.TTTEventListener;
import de.learnlib.algorithms.ttt.base.TTTHypothesis;
import de.learnlib.algorithms.ttt.base.TTTState;
import de.learnlib.algorithms.ttt.base.TTTTransition;
import de.learnlib.api.AccessSequenceTransformer;
import de.learnlib.api.LearningAlgorithm;
import de.learnlib.api.MembershipOracle;
import de.learnlib.counterexamples.LocalSuffixFinder;
import de.learnlib.counterexamples.LocalSuffixFinders;
import de.learnlib.oracles.DefaultQuery;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import javax.annotation.Nonnull;
import net.automatalib.automata.concepts.SuffixOutput;
import net.automatalib.commons.smartcollections.UnorderedCollection;
import net.automatalib.graphs.dot.EmptyDOTHelper;
import net.automatalib.graphs.dot.GraphDOTHelper;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;

public abstract class BaseTTTLearner<A, I, D>
implements LearningAlgorithm<A, I, D>,
AccessSequenceTransformer<I>,
SuffixOutput<I, D> {
    protected final Alphabet<I> alphabet;
    protected final TTTHypothesis<I, D, ?> hypothesis;
    private final MembershipOracle<I, D> oracle;
    protected final DiscriminationTree<I, D> dtree;
    private final Collection<TTTEventListener<I, D>> eventListeners = new UnorderedCollection();
    private final Queue<TTTTransition<I, D>> openTransitions = new ArrayDeque<TTTTransition<I, D>>();
    private final LocalSuffixFinder<? super I, ? super D> suffixFinder;
    private int lastGeneration;
    protected final BlockList<I, D> blockList = new BlockList();

    protected BaseTTTLearner(Alphabet<I> alphabet, MembershipOracle<I, D> oracle, TTTHypothesis<I, D, ?> hypothesis, LocalSuffixFinder<? super I, ? super D> suffixFinder) {
        this.alphabet = alphabet;
        this.hypothesis = hypothesis;
        this.oracle = oracle;
        this.dtree = new DiscriminationTree<I, D>(oracle);
        this.suffixFinder = suffixFinder;
    }

    public void startLearning() {
        if (this.hypothesis.isInitialized()) {
            throw new IllegalStateException();
        }
        TTTState<I, D> init = this.hypothesis.initialize();
        DTNode<I, D> initNode = this.dtree.sift(init);
        BaseTTTLearner.link(initNode, init);
        this.initializeState(init);
        this.closeTransitions();
    }

    public boolean refineHypothesis(DefaultQuery<I, D> ceQuery) {
        if (!this.refineHypothesisSingle(ceQuery)) {
            return false;
        }
        DefaultQuery<I, D> currCe = ceQuery;
        while (this.refineHypothesisSingle(currCe)) {
        }
        return true;
    }

    protected void initializeState(TTTState<I, D> state) {
        for (int i = 0; i < this.alphabet.size(); ++i) {
            Object sym = this.alphabet.getSymbol(i);
            TTTTransition<Object, D> trans = this.createTransition(state, sym);
            trans.setNonTreeTarget(this.dtree.getRoot());
            state.transitions[i] = trans;
            this.openTransitions.offer(trans);
        }
    }

    protected TTTTransition<I, D> createTransition(TTTState<I, D> state, I sym) {
        return new TTTTransition<I, D>(state, sym);
    }

    private boolean refineHypothesisSingle(DefaultQuery<I, D> ceQuery) {
        TTTState<I, D> state = this.getState((Iterable<? extends I>)ceQuery.getPrefix());
        D out = this.computeHypothesisOutput(state, (Iterable<? extends I>)ceQuery.getSuffix());
        if (Objects.equals(out, ceQuery.getOutput())) {
            return false;
        }
        int suffixIdx = this.suffixFinder.findSuffixIndex(ceQuery, (AccessSequenceTransformer)this, (SuffixOutput)this, this.oracle);
        assert (suffixIdx != -1);
        Word ceInput = ceQuery.getInput();
        Word u = ceInput.prefix(suffixIdx - 1);
        Object a = ceInput.getSymbol(suffixIdx - 1);
        int aIdx = this.alphabet.getSymbolIndex(a);
        Word v = ceInput.subWord(suffixIdx);
        TTTState<I, D> pred = this.getState((Iterable<? extends I>)u);
        TTTTransition trans = pred.transitions[aIdx];
        this.splitState(trans, v);
        while (!this.repair()) {
        }
        this.closeTransitions();
        return true;
    }

    protected boolean finalizeAny() {
        GlobalSplitter<I, D> splitter = this.findSplitterGlobal();
        if (splitter != null) {
            this.finalizeDiscriminator(splitter.blockRoot, splitter.localSplitter);
            return true;
        }
        return false;
    }

    private boolean repair() {
        while (this.finalizeAny()) {
        }
        if (this.blockList.isEmpty()) {
            return true;
        }
        DTNode<I, D> blockRoot = this.blockList.chooseBlock();
        this.makeConsistent(blockRoot);
        return false;
    }

    private void makeConsistent(DTNode<I, D> blockRoot) {
        DTNode<I, D> separator = this.chooseInnerNode(blockRoot);
        for (DTNode<I, D> subtreeRoot : separator.getChildren()) {
            DTNode<I, D> leaf = this.chooseLeaf(subtreeRoot);
            if (!this.ensureConsistency(leaf.state, separator, subtreeRoot.getParentEdgeLabel())) continue;
            return;
        }
        assert (false);
    }

    protected DTNode<I, D> chooseInnerNode(DTNode<I, D> root) {
        DTNode<I, D> shortestDiscriminator = null;
        int shortestLen = 0;
        for (DTNode<I, D> node : root.innerNodes()) {
            int discrLen = node.getDiscriminator().length();
            if (shortestDiscriminator != null && discrLen >= shortestLen) continue;
            shortestDiscriminator = node;
            shortestLen = discrLen;
        }
        return shortestDiscriminator;
    }

    protected DTNode<I, D> chooseLeaf(DTNode<I, D> root) {
        DTNode<I, D> shortestPrefix = null;
        int shortestLen = 0;
        for (DTNode<I, D> leaf : root.subtreeLeaves()) {
            int asLen = leaf.state.getAccessSequence().length();
            if (shortestPrefix != null && asLen >= shortestLen) continue;
            shortestPrefix = leaf;
            shortestLen = asLen;
        }
        return shortestPrefix;
    }

    private boolean ensureConsistency(TTTState<I, D> state, DTNode<I, D> dtNode, D realOutcome) {
        Word<I> suffix = dtNode.getDiscriminator();
        D hypOutcome = this.computeHypothesisOutput(state, (Iterable<? extends I>)suffix);
        if (Objects.equals(hypOutcome, realOutcome)) {
            return false;
        }
        this.notifyEnsureConsistency(state, dtNode, realOutcome);
        DefaultQuery query = new DefaultQuery(state.getAccessSequence(), suffix, realOutcome);
        while (this.refineHypothesisSingle(query)) {
        }
        return true;
    }

    private GlobalSplitter<I, D> findSplitterGlobal() {
        boolean optimizeGlobal = true;
        DTNode<I, D> bestBlockRoot = null;
        Splitter<I, D> bestSplitter = null;
        for (DTNode<I, D> blockRoot : this.blockList) {
            Splitter<I, D> splitter = this.findSplitter(blockRoot);
            if (splitter == null) continue;
            if (bestSplitter == null || splitter.discriminator.length() < bestSplitter.discriminator.length()) {
                bestSplitter = splitter;
                bestBlockRoot = blockRoot;
            }
            if (optimizeGlobal) continue;
            break;
        }
        if (bestSplitter == null) {
            return null;
        }
        return new GlobalSplitter(bestBlockRoot, bestSplitter);
    }

    private Splitter<I, D> findSplitter(DTNode<I, D> blockRoot) {
        boolean optimizeLocal = true;
        Iterator<TTTState<I, D>> statesIt = blockRoot.subtreeStatesIterator();
        assert (statesIt.hasNext());
        Object[] properties = new Object[this.alphabet.size()];
        DTNode[] dtTargets = new DTNode[this.alphabet.size()];
        TTTState<I, D> state = statesIt.next();
        for (int i = 0; i < dtTargets.length; ++i) {
            TTTTransition trans = state.transitions[i];
            dtTargets[i] = this.updateDTTarget(trans, false);
            properties[i] = trans.getProperty();
        }
        TTTState<I, D> state1 = state;
        assert (statesIt.hasNext());
        int bestI = -1;
        DTNode<I, D> bestLCA = null;
        TTTState<I, D> state2 = null;
        while (statesIt.hasNext()) {
            state = statesIt.next();
            for (int i = 0; i < dtTargets.length; ++i) {
                TTTTransition trans = state.transitions[i];
                if (!Objects.equals(properties[i], trans.getProperty())) {
                    return new Splitter<I, D>(state1, state, i);
                }
                DTNode tgt1 = dtTargets[i];
                DTNode tgt2 = this.updateDTTarget(trans, false);
                DTNode<I, D> lca = this.dtree.leastCommonAncestor(tgt1, tgt2);
                if (!lca.isTemp() && lca.isInner()) {
                    if (!optimizeLocal) {
                        return new Splitter<I, D>(state1, state, i, lca);
                    }
                    if (bestLCA == null || bestLCA.getDiscriminator().length() > lca.getDiscriminator().length()) {
                        bestI = i;
                        bestLCA = lca;
                        state2 = state;
                    }
                    dtTargets[i] = lca;
                    continue;
                }
                dtTargets[i] = lca;
            }
        }
        if (bestLCA == null) {
            return null;
        }
        return new Splitter<I, D>(state1, state2, bestI, bestLCA);
    }

    private TTTState<I, D> createState(@Nonnull TTTTransition<I, D> transition) {
        TTTState<I, D> newState = this.hypothesis.createState(transition);
        return newState;
    }

    protected TTTState<I, D> getTarget(TTTTransition<I, D> trans) {
        if (trans.isTree()) {
            return trans.getTreeTarget();
        }
        return this.updateTarget(trans);
    }

    protected TTTState<I, D> getState(TTTState<I, D> start, Iterable<? extends I> suffix) {
        TTTState<I, D> curr = start;
        for (I sym : suffix) {
            TTTTransition<I, D> trans = this.hypothesis.getInternalTransition(curr, sym);
            curr = this.getTarget(trans);
        }
        return curr;
    }

    private TTTState<I, D> getState(Iterable<? extends I> suffix) {
        return this.getState((TTTState<I, D>)this.hypothesis.getInitialState(), suffix);
    }

    private void finalizeDiscriminator(DTNode<I, D> blockRoot, Splitter<I, D> splitter) {
        assert (blockRoot.isBlockRoot());
        this.notifyPreFinalizeDiscriminator(blockRoot, splitter);
        Word<I> finalDiscriminator = this.prepareSplit(blockRoot, splitter);
        Map<D, DTNode<I, D>> repChildren = this.createMap();
        for (Object label : blockRoot.splitData.getLabels()) {
            repChildren.put(label, this.extractSubtree(blockRoot, label));
        }
        blockRoot.replaceChildren(repChildren);
        blockRoot.setDiscriminator(finalDiscriminator);
        this.declareFinal(blockRoot);
        this.notifyPostFinalizeDiscriminator(blockRoot, splitter);
    }

    protected void declareFinal(DTNode<I, D> blockRoot) {
        blockRoot.temp = false;
        blockRoot.splitData = null;
        blockRoot.removeFromBlockList();
        for (DTNode<I, D> subtree : blockRoot.getChildren()) {
            assert (subtree.splitData == null);
            blockRoot.setChild(subtree.getParentEdgeLabel(), subtree);
            if (!subtree.isInner()) continue;
            this.blockList.insertBlock(subtree);
        }
    }

    private Word<I> prepareSplit(DTNode<I, D> node, Splitter<I, D> splitter) {
        int symbolIdx = splitter.symbolIdx;
        Object symbol = this.alphabet.getSymbol(symbolIdx);
        Word discriminator = splitter.discriminator.prepend(symbol);
        ArrayDeque<DTNode> dfsStack = new ArrayDeque<DTNode>();
        DTNode succSeparator = splitter.succSeparator;
        dfsStack.push(node);
        assert (node.splitData == null);
        while (!dfsStack.isEmpty()) {
            D outcome;
            DTNode curr = (DTNode)dfsStack.pop();
            assert (curr.splitData == null);
            curr.splitData = new SplitData();
            for (TTTTransition tTTTransition : curr.getIncoming()) {
                outcome = this.query(tTTTransition, discriminator);
                curr.splitData.getIncoming(outcome).insertIncoming(tTTTransition);
                BaseTTTLearner.markAndPropagate(curr, outcome);
            }
            if (curr.isInner()) {
                for (DTNode dTNode : curr.getChildren()) {
                    dfsStack.push(dTNode);
                }
                continue;
            }
            TTTState state = curr.state;
            assert (state != null);
            TTTTransition tTTTransition = state.transitions[symbolIdx];
            outcome = this.predictSuccOutcome(tTTTransition, succSeparator);
            if (outcome == null) {
                outcome = this.query(state, discriminator);
            }
            curr.splitData.setStateLabel(outcome);
            BaseTTTLearner.markAndPropagate(curr, outcome);
        }
        return discriminator;
    }

    protected D predictSuccOutcome(TTTTransition<I, D> trans, DTNode<I, D> succSeparator) {
        return null;
    }

    private static <I, D> void markAndPropagate(DTNode<I, D> node, D label) {
        for (DTNode<I, D> curr = node; curr != null && curr.splitData != null; curr = curr.getParent()) {
            if (curr.splitData.mark(label)) continue;
            return;
        }
    }

    private DTNode<I, D> extractSubtree(DTNode<I, D> root, D label) {
        assert (root.splitData != null);
        assert (root.splitData.isMarked(label));
        ArrayDeque stack = new ArrayDeque();
        DTNode<I, D> firstExtracted = new DTNode<I, D>(root, label);
        stack.push(new ExtractRecord<I, D>(root, firstExtracted));
        while (!stack.isEmpty()) {
            ExtractRecord curr = (ExtractRecord)stack.pop();
            DTNode original = curr.original;
            DTNode extracted = curr.extracted;
            BaseTTTLearner.moveIncoming(extracted, original, label);
            if (original.isLeaf()) {
                if (Objects.equals(original.splitData.getStateLabel(), label)) {
                    BaseTTTLearner.link(extracted, original.state);
                } else {
                    this.createNewState(extracted);
                }
                extracted.updateIncoming();
            } else {
                ArrayList markedChildren = new ArrayList();
                for (DTNode child : original.getChildren()) {
                    if (!child.splitData.isMarked(label)) continue;
                    markedChildren.add(child);
                }
                if (markedChildren.size() > 1) {
                    Map childMap = this.createMap();
                    for (DTNode dTNode : markedChildren) {
                        Object childLabel = dTNode.getParentEdgeLabel();
                        DTNode extractedChild = new DTNode(extracted, childLabel);
                        childMap.put(childLabel, extractedChild);
                        stack.push(new ExtractRecord(dTNode, extractedChild));
                    }
                    extracted.split(original.getDiscriminator(), childMap);
                    extracted.updateIncoming();
                    extracted.temp = true;
                } else if (markedChildren.size() == 1) {
                    stack.push(new ExtractRecord((DTNode)markedChildren.get(0), extracted));
                } else {
                    this.createNewState(extracted);
                    extracted.updateIncoming();
                }
            }
            assert (extracted.splitData == null);
        }
        return firstExtracted;
    }

    protected <V> Map<D, V> createMap() {
        return new HashMap();
    }

    private static <I, D> void moveIncoming(DTNode<I, D> newNode, DTNode<I, D> oldNode, D label) {
        newNode.getIncoming().insertAllIncoming(oldNode.splitData.getIncoming(label));
    }

    private void createNewState(DTNode<I, D> newNode) {
        TTTTransition<I, D> newTreeTrans = newNode.getIncoming().choose();
        assert (newTreeTrans != null);
        TTTState<I, D> newState = this.createState(newTreeTrans);
        BaseTTTLearner.link(newNode, newState);
        this.initializeState(newState);
    }

    protected abstract D computeHypothesisOutput(TTTState<I, D> var1, Iterable<? extends I> var2);

    private static <I, D> void link(DTNode<I, D> dtNode, TTTState<I, D> state) {
        assert (dtNode.isLeaf());
        dtNode.state = state;
        state.dtLeaf = dtNode;
    }

    public D computeOutput(Iterable<? extends I> input) {
        return this.computeHypothesisOutput((TTTState<I, D>)this.hypothesis.getInitialState(), input);
    }

    public D computeSuffixOutput(Iterable<? extends I> prefix, Iterable<? extends I> suffix) {
        TTTState<? extends I, D> prefixState = this.getState(prefix);
        return this.computeHypothesisOutput(prefixState, suffix);
    }

    public Word<I> transformAccessSequence(Word<I> word) {
        return this.getState((Iterable<? extends I>)word).getAccessSequence();
    }

    public boolean isAccessSequence(Word<I> word) {
        TTTState<I, D> curr = this.hypothesis.getInitialState();
        for (Object sym : word) {
            TTTTransition<I, D> trans = this.hypothesis.getInternalTransition(curr, sym);
            if (!trans.isTree()) {
                return false;
            }
            curr = trans.getTarget();
        }
        return true;
    }

    public TTTHypothesis<I, D, ?> getHypothesisDS() {
        return this.hypothesis;
    }

    public DiscriminationTree.GraphView dtGraphView() {
        return this.dtree.graphView();
    }

    public GraphDOTHelper<TTTState<I, D>, TTTHypothesis.TTTEdge<I, D>> getHypothesisDOTHelper() {
        return new EmptyDOTHelper();
    }

    private DTNode<I, D> splitState(TTTTransition<I, D> transition, Word<I> tempDiscriminator) {
        assert (!transition.isTree());
        this.notifyPreSplit(transition, tempDiscriminator);
        DTNode<I, D> dtNode = transition.getNonTreeTarget();
        TTTState oldState = dtNode.state;
        assert (oldState != null);
        TTTState<I, D> newState = this.createState(transition);
        D oldOut = this.query(oldState, tempDiscriminator);
        D newOut = this.query(newState, tempDiscriminator);
        DTNode<I, Object>[] children = this.split(dtNode, tempDiscriminator, oldOut, newOut);
        BaseTTTLearner.link(children[0], oldState);
        BaseTTTLearner.link(children[1], newState);
        this.initializeState(newState);
        if (this.isOld(oldState)) {
            for (TTTTransition<I, D> incoming : dtNode.getIncoming()) {
                this.openTransitions.offer(incoming);
            }
        }
        dtNode.temp = true;
        if (dtNode.getParent() == null || !dtNode.getParent().isTemp()) {
            this.blockList.insertBlock(dtNode);
        }
        this.notifyPostSplit(transition, tempDiscriminator);
        return dtNode;
    }

    private boolean isOld(@Nonnull TTTState<I, D> state) {
        return state.id < this.lastGeneration;
    }

    private void closeTransitions() {
        while (!this.openTransitions.isEmpty()) {
            TTTTransition<I, D> trans = this.openTransitions.poll();
            this.closeTransition(trans);
        }
        this.lastGeneration = this.hypothesis.size();
    }

    private void closeTransition(TTTTransition<I, D> trans) {
        if (trans.isTree()) {
            return;
        }
        this.updateTarget(trans);
    }

    private DTNode<I, D> updateDTTarget(TTTTransition<I, D> transition) {
        return this.updateDTTarget(transition, true);
    }

    private TTTState<I, D> updateTarget(TTTTransition<I, D> trans) {
        DTNode<I, D> node = this.updateDTTarget(trans);
        TTTState state = node.state;
        if (state == null) {
            state = this.createState(trans);
            BaseTTTLearner.link(node, state);
            this.initializeState(state);
        }
        return state;
    }

    private DTNode<I, D> updateDTTarget(TTTTransition<I, D> transition, boolean hard) {
        if (transition.isTree()) {
            return transition.getTreeTarget().dtLeaf;
        }
        DTNode<I, D> dt = transition.getNonTreeTarget();
        dt = this.dtree.sift(dt, transition, hard);
        transition.setNonTreeTarget(dt);
        return dt;
    }

    protected D query(Word<I> prefix, Word<I> suffix) {
        return (D)this.oracle.answerQuery(prefix, suffix);
    }

    protected D query(AccessSequenceProvider<I> accessSeqProvider, Word<I> suffix) {
        return this.query(accessSeqProvider.getAccessSequence(), suffix);
    }

    public DiscriminationTree<I, D> getDiscriminationTree() {
        return this.dtree;
    }

    @SafeVarargs
    protected final DTNode<I, D>[] split(DTNode<I, D> node, Word<I> discriminator, D ... outputs) {
        return node.split(discriminator, this.createMap(), outputs);
    }

    private void notifyPreFinalizeDiscriminator(DTNode<I, D> blockRoot, Splitter<I, D> splitter) {
        for (TTTEventListener<I, D> listener : this.eventListeners()) {
            listener.preFinalizeDiscriminator(blockRoot, splitter);
        }
    }

    private void notifyPostFinalizeDiscriminator(DTNode<I, D> blockRoot, Splitter<I, D> splitter) {
        for (TTTEventListener<I, D> listener : this.eventListeners()) {
            listener.postFinalizeDiscriminator(blockRoot, splitter);
        }
    }

    private void notifyEnsureConsistency(TTTState<I, D> state, DTNode<I, D> discriminator, D realOutcome) {
        for (TTTEventListener<I, D> listener : this.eventListeners()) {
            listener.ensureConsistency(state, discriminator, realOutcome);
        }
    }

    private void notifyPreSplit(TTTTransition<I, D> transition, Word<I> tempDiscriminator) {
        for (TTTEventListener<I, D> listener : this.eventListeners()) {
            listener.preSplit(transition, tempDiscriminator);
        }
    }

    private void notifyPostSplit(TTTTransition<I, D> transition, Word<I> tempDiscriminator) {
        for (TTTEventListener<I, D> listener : this.eventListeners()) {
            listener.postSplit(transition, tempDiscriminator);
        }
    }

    private Iterable<TTTEventListener<I, D>> eventListeners() {
        return this.eventListeners;
    }

    public void addEventListener(TTTEventListener<I, D> listener) {
        this.eventListeners.add(listener);
    }

    public void removeEventListener(TTTEventListener<I, D> listener) {
        this.eventListeners.remove(listener);
    }

    private static final class ExtractRecord<I, D> {
        public final DTNode<I, D> original;
        public final DTNode<I, D> extracted;

        public ExtractRecord(DTNode<I, D> original, DTNode<I, D> extracted) {
            this.original = original;
            this.extracted = extracted;
        }
    }

    private static final class GlobalSplitter<I, D> {
        public final Splitter<I, D> localSplitter;
        public final DTNode<I, D> blockRoot;

        public GlobalSplitter(DTNode<I, D> blockRoot, Splitter<I, D> localSplitter) {
            this.blockRoot = blockRoot;
            this.localSplitter = localSplitter;
        }
    }

    public static final class Splitter<I, D> {
        public final TTTState<I, D> state1;
        public final TTTState<I, D> state2;
        public final int symbolIdx;
        public final DTNode<I, D> succSeparator;
        public final Word<I> discriminator;

        public Splitter(TTTState<I, D> state1, TTTState<I, D> state2, int symbolIdx) {
            this.state1 = state1;
            this.state2 = state2;
            this.symbolIdx = symbolIdx;
            this.succSeparator = null;
            this.discriminator = Word.epsilon();
        }

        public Splitter(TTTState<I, D> state1, TTTState<I, D> state2, int symbolIdx, DTNode<I, D> succSeparator) {
            assert (!succSeparator.isTemp() && succSeparator.isInner());
            this.state1 = state1;
            this.state2 = state2;
            this.symbolIdx = symbolIdx;
            this.succSeparator = succSeparator;
            this.discriminator = succSeparator.getDiscriminator();
        }
    }

    public static class BuilderDefaults {
        public static <I, D> LocalSuffixFinder<? super I, ? super D> suffixFinder() {
            return LocalSuffixFinders.RIVEST_SCHAPIRE;
        }
    }
}

