/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.ttt.mealy;

import de.learnlib.algorithms.ttt.base.BaseTTTLearner;
import de.learnlib.algorithms.ttt.base.DTNode;
import de.learnlib.algorithms.ttt.base.TTTState;
import de.learnlib.algorithms.ttt.base.TTTTransition;
import de.learnlib.algorithms.ttt.mealy.TTTHypothesisMealy;
import de.learnlib.algorithms.ttt.mealy.TTTTransitionMealy;
import de.learnlib.api.MembershipOracle;
import de.learnlib.counterexamples.LocalSuffixFinder;
import net.automatalib.automata.transout.MealyMachine;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;

public class TTTLearnerMealy<I, O>
extends BaseTTTLearner<MealyMachine<?, I, ?, O>, I, Word<O>> {
    public TTTLearnerMealy(Alphabet<I> alphabet, MembershipOracle<I, Word<O>> oracle, LocalSuffixFinder<? super I, ? super Word<O>> suffixFinder) {
        super(alphabet, oracle, new TTTHypothesisMealy(alphabet), suffixFinder);
    }

    public MealyMachine<?, I, ?, O> getHypothesisModel() {
        return (TTTHypothesisMealy)this.hypothesis;
    }

    @Override
    protected TTTTransition<I, Word<O>> createTransition(TTTState<I, Word<O>> state, I sym) {
        TTTTransitionMealy<I, O> trans = new TTTTransitionMealy<I, O>(state, sym);
        trans.output = ((Word)this.query(state, Word.fromLetter(sym))).firstSymbol();
        return trans;
    }

    @Override
    protected Word<O> predictSuccOutcome(TTTTransition<I, Word<O>> trans, DTNode<I, Word<O>> succSeparator) {
        TTTTransitionMealy mtrans = (TTTTransitionMealy)trans;
        if (succSeparator == null) {
            return Word.fromLetter(mtrans.output);
        }
        return succSeparator.subtreeLabel(trans.getDTTarget()).prepend(mtrans.output);
    }

    @Override
    protected Word<O> computeHypothesisOutput(TTTState<I, Word<O>> state, Iterable<? extends I> suffix) {
        TTTState<I, Object> curr = state;
        WordBuilder wb = new WordBuilder();
        for (I sym : suffix) {
            TTTTransitionMealy trans = (TTTTransitionMealy)this.hypothesis.getInternalTransition(curr, sym);
            wb.append(trans.output);
            curr = this.getTarget(trans);
        }
        return wb.toWord();
    }
}

