/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.ttt.base;

import de.learnlib.algorithms.ttt.base.TTTState;
import de.learnlib.algorithms.ttt.base.TTTTransition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.automatalib.automata.DeterministicAutomaton;
import net.automatalib.automata.FiniteAlphabetAutomaton;
import net.automatalib.graphs.Graph;
import net.automatalib.graphs.dot.DefaultDOTHelper;
import net.automatalib.graphs.dot.GraphDOTHelper;
import net.automatalib.words.Alphabet;

public abstract class TTTHypothesis<I, D, T>
implements DeterministicAutomaton<TTTState<I, D>, I, T>,
FiniteAlphabetAutomaton<TTTState<I, D>, I, T> {
    private final List<TTTState<I, D>> states = new ArrayList<TTTState<I, D>>();
    protected final Alphabet<I> alphabet;
    private TTTState<I, D> initialState;

    public TTTHypothesis(Alphabet<I> alphabet) {
        this.alphabet = alphabet;
    }

    public Collection<TTTState<I, D>> getStates() {
        return Collections.unmodifiableList(this.states);
    }

    public TTTState<I, D> getInitialState() {
        return this.initialState;
    }

    public T getTransition(TTTState<I, D> state, I input) {
        TTTTransition<I, D> trans = this.getInternalTransition(state, input);
        return this.mapTransition(trans);
    }

    protected abstract T mapTransition(TTTTransition<I, D> var1);

    public boolean isInitialized() {
        return this.initialState != null;
    }

    public TTTState<I, D> initialize() {
        assert (!this.isInitialized());
        this.initialState = this.createState(null);
        return this.initialState;
    }

    public TTTTransition<I, D> getInternalTransition(TTTState<I, D> state, I input) {
        int inputIdx = this.alphabet.getSymbolIndex(input);
        TTTTransition trans = state.transitions[inputIdx];
        return trans;
    }

    public TTTState<I, D> createState(TTTTransition<I, D> parent) {
        TTTState<I, D> state = this.newState(this.alphabet.size(), parent, this.states.size());
        this.states.add(state);
        if (parent != null) {
            parent.makeTree(state);
        }
        return state;
    }

    protected TTTState<I, D> newState(int alphabetSize, TTTTransition<I, D> parent, int id) {
        return new TTTState<I, D>(alphabetSize, parent, id);
    }

    public Alphabet<I> getInputAlphabet() {
        return this.alphabet;
    }

    public GraphView graphView() {
        return new GraphView();
    }

    public class GraphView
    implements Graph<TTTState<I, D>, TTTEdge<I, D>> {
        public Collection<? extends TTTState<I, D>> getNodes() {
            return TTTHypothesis.this.states;
        }

        public Collection<? extends TTTEdge<I, D>> getOutgoingEdges(TTTState<I, D> node) {
            ArrayList result = new ArrayList();
            for (TTTTransition trans : node.transitions) {
                for (TTTState target : trans.getDTTarget().subtreeStates()) {
                    result.add(new TTTEdge(trans, target));
                }
            }
            return result;
        }

        public TTTState<I, D> getTarget(TTTEdge<I, D> edge) {
            return edge.target;
        }

        public GraphDOTHelper<TTTState<I, D>, TTTEdge<I, D>> getGraphDOTHelper() {
            return new DefaultDOTHelper<TTTState<I, D>, TTTEdge<I, D>>(){

                public boolean getEdgeProperties(TTTState<I, D> src, TTTEdge<I, D> edge, TTTState<I, D> tgt, Map<String, String> properties) {
                    properties.put("label", String.valueOf(edge.transition.getInput()));
                    if (edge.transition.isTree()) {
                        properties.put("style", "bold");
                    } else if (edge.transition.getDTTarget().isInner()) {
                        properties.put("style", "dotted");
                    }
                    return true;
                }
            };
        }
    }

    public static final class TTTEdge<I, D> {
        public final TTTTransition<I, D> transition;
        public final TTTState<I, D> target;

        public TTTEdge(TTTTransition<I, D> transition, TTTState<I, D> target) {
            this.transition = transition;
            this.target = target;
        }
    }
}

