/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.ttt.base;

import com.google.common.collect.Iterators;
import de.learnlib.algorithms.ttt.base.AccessSequenceProvider;
import de.learnlib.algorithms.ttt.base.DTNode;
import de.learnlib.api.MembershipOracle;
import de.learnlib.oracles.MQUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.automatalib.graphs.Graph;
import net.automatalib.graphs.dot.DefaultDOTHelper;
import net.automatalib.graphs.dot.GraphDOTHelper;
import net.automatalib.words.Word;

public class DiscriminationTree<I, D> {
    private final DTNode<I, D> root = new DTNode();
    private final MembershipOracle<I, D> oracle;

    public DiscriminationTree(MembershipOracle<I, D> oracle) {
        this.oracle = oracle;
    }

    public DTNode<I, D> getRoot() {
        return this.root;
    }

    public DTNode<I, D> sift(AccessSequenceProvider<I> asp) {
        return this.sift(asp, true);
    }

    public DTNode<I, D> sift(AccessSequenceProvider<I> asp, boolean hard) {
        return this.sift(asp.getAccessSequence(), hard);
    }

    public DTNode<I, D> sift(Word<I> word) {
        return this.sift(word, true);
    }

    public DTNode<I, D> sift(Word<I> word, boolean hard) {
        return this.sift(this.root, word, hard);
    }

    public DTNode<I, D> sift(DTNode<I, D> start, AccessSequenceProvider<I> asp, boolean hard) {
        return this.sift(start, asp.getAccessSequence(), hard);
    }

    public DTNode<I, D> sift(DTNode<I, D> start, Word<I> word, boolean hard) {
        DTNode<I, D> curr = start;
        while (!(curr.isLeaf() || !hard && curr.isTemp())) {
            D outcome = this.mqOut(word, curr.getDiscriminator());
            curr = curr.child(outcome);
        }
        return curr;
    }

    public DTNode<I, D> leastCommonAncestor(DTNode<I, D> node1, DTNode<I, D> node2) {
        DTNode<I, D> curr2;
        DTNode<I, D> curr1;
        int ddiff = node1.getDepth() - node2.getDepth();
        if (ddiff < 0) {
            curr1 = node2;
            curr2 = node1;
            ddiff *= -1;
        } else {
            curr1 = node1;
            curr2 = node2;
        }
        for (int i = 0; i < ddiff; ++i) {
            curr1 = curr1.getParent();
        }
        while (curr1 != curr2) {
            curr1 = curr1.getParent();
            curr2 = curr2.getParent();
        }
        return curr1;
    }

    private D mqOut(Word<I> prefix, Word<I> suffix) {
        return (D)MQUtil.output(this.oracle, prefix, suffix);
    }

    public GraphView graphView() {
        return new GraphView();
    }

    public class GraphView
    implements Graph<DTNode<I, D>, DTNode<I, D>> {
        public Collection<? extends DTNode<I, D>> getNodes() {
            ArrayList nodes = new ArrayList();
            Iterators.addAll(nodes, DiscriminationTree.this.root.subtreeNodesIterator());
            return nodes;
        }

        public Collection<? extends DTNode<I, D>> getOutgoingEdges(DTNode<I, D> node) {
            if (node.isLeaf()) {
                return Collections.emptyList();
            }
            return node.getChildren();
        }

        public DTNode<I, D> getTarget(DTNode<I, D> edge) {
            return edge;
        }

        public GraphDOTHelper<DTNode<I, D>, DTNode<I, D>> getGraphDOTHelper() {
            return new DefaultDOTHelper<DTNode<I, D>, DTNode<I, D>>(){

                public boolean getNodeProperties(DTNode<I, D> node, Map<String, String> properties) {
                    if (node.isLeaf()) {
                        properties.put("shape", "box");
                        properties.put("label", String.valueOf(node.state));
                    } else {
                        properties.put("label", node.getDiscriminator().toString());
                        if (!node.isTemp()) {
                            properties.put("shape", "oval");
                        } else if (node.isBlockRoot()) {
                            properties.put("shape", "doubleoctagon");
                        } else {
                            properties.put("shape", "octagon");
                        }
                    }
                    return true;
                }

                public boolean getEdgeProperties(DTNode<I, D> src, DTNode<I, D> edge, DTNode<I, D> tgt, Map<String, String> properties) {
                    properties.put("label", String.valueOf(edge.getParentEdgeLabel()));
                    return true;
                }
            };
        }
    }
}

