/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.ttt.base;

import com.google.common.collect.AbstractIterator;
import de.learnlib.algorithms.ttt.base.BlockListElem;
import de.learnlib.algorithms.ttt.base.IncomingList;
import de.learnlib.algorithms.ttt.base.SplitData;
import de.learnlib.algorithms.ttt.base.TTTState;
import de.learnlib.algorithms.ttt.base.TTTTransition;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import net.automatalib.words.Word;

public class DTNode<I, D>
extends BlockListElem<I, D> {
    private final DTNode<I, D> parent;
    private final D parentEdgeLabel;
    private final int depth;
    SplitData<I, D> splitData = null;
    private final IncomingList<I, D> incoming = new IncomingList();
    private Word<I> discriminator;
    private Map<D, DTNode<I, D>> children;
    BlockListElem<I, D> prevBlock;
    TTTState<I, D> state;
    boolean temp = false;

    public DTNode() {
        this(null, null);
    }

    public DTNode(DTNode<I, D> parent, D parentEdgeLabel) {
        this.parent = parent;
        this.parentEdgeLabel = parentEdgeLabel;
        this.depth = parent != null ? parent.depth + 1 : 0;
    }

    public Word<I> getDiscriminator() {
        return this.discriminator;
    }

    public TTTState<I, D> getState() {
        assert (this.isLeaf());
        return this.state;
    }

    public boolean isInner() {
        return this.discriminator != null;
    }

    public boolean isLeaf() {
        return this.discriminator == null;
    }

    public Collection<? extends Map.Entry<D, DTNode<I, D>>> getChildEntries() {
        return this.children.entrySet();
    }

    public Collection<? extends DTNode<I, D>> getChildren() {
        return this.children.values();
    }

    public DTNode<I, D> getExtremalChild(D label) {
        DTNode<I, D> curr = this;
        while (!curr.isLeaf()) {
            curr = curr.getChild(label);
        }
        return curr;
    }

    public void setChild(D label, DTNode<I, D> newChild) {
        assert (newChild.parent == this);
        assert (Objects.equals(newChild.parentEdgeLabel, label));
        this.children.put(label, newChild);
    }

    public DTNode<I, D> getChild(D value) {
        assert (this.isInner());
        return this.children.get(value);
    }

    public DTNode<I, D> child(D value) {
        assert (this.isInner());
        DTNode<I, D> child = this.children.get(value);
        if (child == null) {
            child = new DTNode<I, D>(this, value);
            this.children.put(value, child);
        }
        return child;
    }

    public DTNode<I, D> getParent() {
        return this.parent;
    }

    public D getParentEdgeLabel() {
        return this.parentEdgeLabel;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean isTemp() {
        return this.temp;
    }

    public Iterable<TTTState<I, D>> subtreeStates() {
        return new Iterable<TTTState<I, D>>(){

            @Override
            public Iterator<TTTState<I, D>> iterator() {
                return DTNode.this.subtreeStatesIterator();
            }
        };
    }

    public Iterator<TTTState<I, D>> subtreeStatesIterator() {
        return new StatesIterator(this);
    }

    void split(Word<I> discriminator, Map<D, DTNode<I, D>> newChildMap) {
        assert (this.state == null);
        this.discriminator = discriminator;
        this.children = newChildMap;
    }

    @SafeVarargs
    final DTNode<I, D>[] split(Word<I> discriminator, Map<D, DTNode<I, D>> newChildMap, D ... outputs) {
        int numOutputs = outputs.length;
        assert (numOutputs > 1);
        DTNode[] children = new DTNode[numOutputs];
        this.state = null;
        this.split(discriminator, newChildMap);
        for (int i = 0; i < numOutputs; ++i) {
            D output = outputs[i];
            DTNode<I, D> child = new DTNode<I, D>(this, output);
            this.children.put(output, child);
            children[i] = child;
        }
        return children;
    }

    public IncomingList<I, D> getIncoming() {
        return this.incoming;
    }

    public Iterator<DTNode<I, D>> subtreeLeavesIterator() {
        return new LeavesIterator(this);
    }

    public Iterable<DTNode<I, D>> subtreeLeaves() {
        return new Iterable<DTNode<I, D>>(){

            @Override
            public Iterator<DTNode<I, D>> iterator() {
                return DTNode.this.subtreeLeavesIterator();
            }
        };
    }

    public Iterator<DTNode<I, D>> innerNodesIterator() {
        return new InnerNodesIterator(this);
    }

    public Iterable<DTNode<I, D>> innerNodes() {
        return new Iterable<DTNode<I, D>>(){

            @Override
            public Iterator<DTNode<I, D>> iterator() {
                return DTNode.this.innerNodesIterator();
            }
        };
    }

    public Iterator<DTNode<I, D>> subtreeNodesIterator() {
        return new NodesIterator(this);
    }

    public D subtreeLabel(DTNode<I, D> descendant) {
        DTNode<I, D> curr = descendant;
        while (curr.depth > this.depth + 1) {
            curr = curr.parent;
        }
        if (curr.parent != this) {
            return null;
        }
        return curr.parentEdgeLabel;
    }

    void replaceChildren(Map<D, DTNode<I, D>> repChildren) {
        this.children = repChildren;
    }

    void updateIncoming() {
        for (TTTTransition<I, D> trans : this.incoming) {
            trans.nonTreeTarget = this;
        }
    }

    boolean isBlockRoot() {
        return this.prevBlock != null;
    }

    DTNode<I, D> getBlockRoot() {
        DTNode<I, D> curr = this;
        while (curr != null && !curr.isBlockRoot()) {
            curr = curr.parent;
        }
        return curr;
    }

    void removeFromBlockList() {
        if (this.prevBlock != null) {
            this.prevBlock.nextBlock = this.nextBlock;
            if (this.nextBlock != null) {
                this.nextBlock.prevBlock = this.prevBlock;
            }
            this.nextBlock = null;
            this.prevBlock = null;
        }
    }

    void setDiscriminator(Word<I> newDiscriminator) {
        assert (this.isInner());
        this.discriminator = newDiscriminator;
    }

    private static final class NodesIterator<I, D>
    extends AbstractIterator<DTNode<I, D>> {
        private final Deque<DTNode<I, D>> stack = new ArrayDeque<DTNode<I, D>>();

        public NodesIterator(DTNode<I, D> root) {
            this.stack.push(root);
        }

        protected DTNode<I, D> computeNext() {
            if (!this.stack.isEmpty()) {
                DTNode<I, D> curr = this.stack.pop();
                if (curr.isInner()) {
                    for (DTNode<I, D> child : curr.getChildren()) {
                        this.stack.push(child);
                    }
                }
                return curr;
            }
            return (DTNode)this.endOfData();
        }
    }

    private static final class InnerNodesIterator<I, D>
    extends AbstractIterator<DTNode<I, D>> {
        private final Deque<DTNode<I, D>> stack = new ArrayDeque<DTNode<I, D>>();

        public InnerNodesIterator(DTNode<I, D> root) {
            if (root.isInner()) {
                this.stack.push(root);
            }
        }

        protected DTNode<I, D> computeNext() {
            while (!this.stack.isEmpty()) {
                DTNode<I, D> curr = this.stack.pop();
                if (!curr.isInner()) continue;
                for (DTNode<I, D> child : curr.getChildren()) {
                    this.stack.push(child);
                }
                return curr;
            }
            return (DTNode)this.endOfData();
        }
    }

    private static final class LeavesIterator<I, D>
    extends AbstractIterator<DTNode<I, D>> {
        private final Deque<DTNode<I, D>> stack = new ArrayDeque<DTNode<I, D>>();

        public LeavesIterator(DTNode<I, D> root) {
            this.stack.push(root);
        }

        protected DTNode<I, D> computeNext() {
            while (!this.stack.isEmpty()) {
                DTNode<I, D> curr = this.stack.pop();
                if (curr.isLeaf()) {
                    return curr;
                }
                for (DTNode<I, D> child : curr.getChildren()) {
                    this.stack.push(child);
                }
            }
            return (DTNode)this.endOfData();
        }
    }

    private static final class StatesIterator<I, D>
    extends AbstractIterator<TTTState<I, D>> {
        private final Deque<DTNode<I, D>> stack = new ArrayDeque<DTNode<I, D>>();

        public StatesIterator(DTNode<I, D> root) {
            this.stack.push(root);
        }

        protected TTTState<I, D> computeNext() {
            while (!this.stack.isEmpty()) {
                DTNode<I, D> curr = this.stack.pop();
                if (curr.isLeaf()) {
                    if (curr.state == null) continue;
                    return curr.state;
                }
                for (DTNode<I, D> child : curr.getChildren()) {
                    this.stack.push(child);
                }
            }
            return (TTTState)this.endOfData();
        }
    }
}

