/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.ttt.vpda;

import com.google.common.collect.Iterables;
import de.learnlib.acex.AbstractCounterexample;
import de.learnlib.acex.AcexAnalyzer;
import de.learnlib.algorithms.discriminationtree.hypothesis.vpda.AbstractHypTrans;
import de.learnlib.algorithms.discriminationtree.hypothesis.vpda.BlockList;
import de.learnlib.algorithms.discriminationtree.hypothesis.vpda.ContextPair;
import de.learnlib.algorithms.discriminationtree.hypothesis.vpda.DTNode;
import de.learnlib.algorithms.discriminationtree.hypothesis.vpda.HypLoc;
import de.learnlib.algorithms.discriminationtree.hypothesis.vpda.TransList;
import de.learnlib.algorithms.discriminationtree.vpda.DTLearnerVPDA;
import de.learnlib.algorithms.ttt.vpda.ExtractRecord;
import de.learnlib.algorithms.ttt.vpda.GlobalSplitter;
import de.learnlib.algorithms.ttt.vpda.NonDetState;
import de.learnlib.algorithms.ttt.vpda.NondetStackContents;
import de.learnlib.algorithms.ttt.vpda.OutputInconsistency;
import de.learnlib.algorithms.ttt.vpda.Splitter;
import de.learnlib.api.AccessSequenceProvider;
import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.api.query.DefaultQuery;
import de.learnlib.datastructure.discriminationtree.SplitData;
import de.learnlib.datastructure.discriminationtree.model.AbstractDTNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import net.automatalib.automata.vpda.StackContents;
import net.automatalib.automata.vpda.State;
import net.automatalib.words.VPDAlphabet;
import net.automatalib.words.Word;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TTTLearnerVPDA<I>
extends DTLearnerVPDA<I> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TTTLearnerVPDA.class);
    private final BlockList<I> blockList = new BlockList();

    public TTTLearnerVPDA(VPDAlphabet<I> alphabet, MembershipOracle<I, Boolean> oracle, AcexAnalyzer analyzer) {
        super(alphabet, oracle, analyzer);
    }

    protected State<HypLoc<I>> getDefinitiveSuccessor(State<HypLoc<I>> baseState, Word<I> suffix) {
        NonDetState<Object> curr = NonDetState.fromDet(baseState);
        int lastDet = 0;
        NonDetState<Object> lastDetState = curr;
        int i = 0;
        for (Object sym : suffix) {
            HashSet<HypLoc> succs;
            if (this.alphabet.isCallSymbol(sym)) {
                HashSet<Integer> stackSyms = new HashSet<Integer>();
                for (HypLoc<I> loc : curr.getLocations()) {
                    int stackSym = this.hypothesis.encodeStackSym(loc, sym);
                    stackSyms.add(stackSym);
                }
                NondetStackContents nsc = NondetStackContents.push(stackSyms, curr.getStack());
                curr = new NonDetState<HypLoc>(Collections.singleton(this.hypothesis.getInitialLocation()), nsc);
            } else if (this.alphabet.isReturnSymbol(sym)) {
                succs = new HashSet<HypLoc>();
                for (HypLoc<I> loc : curr.getLocations()) {
                    for (int stackSym : curr.getStack().peek()) {
                        AbstractHypTrans trans = this.hypothesis.getReturnTransition(loc, sym, stackSym);
                        if (trans.isTree()) {
                            succs.add(trans.getTreeTarget());
                            continue;
                        }
                        Iterables.addAll(succs, (Iterable)trans.getNonTreeTarget().subtreeLocations());
                    }
                }
                curr = new NonDetState(succs, curr.getStack().pop());
            } else {
                succs = new HashSet();
                for (HypLoc<I> loc : curr.getLocations()) {
                    AbstractHypTrans trans = this.hypothesis.getInternalTransition(loc, sym);
                    if (trans.isTree()) {
                        succs.add(trans.getTreeTarget());
                        continue;
                    }
                    Iterables.addAll(succs, (Iterable)trans.getNonTreeTarget().subtreeLocations());
                }
                curr = new NonDetState(succs, curr.getStack());
            }
            ++i;
            if (curr.isNonDet()) continue;
            lastDet = i;
            lastDetState = curr;
        }
        if (lastDet < suffix.length()) {
            LOGGER.debug("last det: {}", (Object)lastDet);
            this.determinize(lastDetState.determinize(), suffix.subWord(lastDet));
        }
        return (State)this.hypothesis.getSuccessor(baseState, suffix);
    }

    protected boolean refineHypothesisSingle(DefaultQuery<I, Boolean> ceQuery) {
        Word ceWord = ceQuery.getInput();
        Boolean out = this.computeHypothesisOutput(ceWord);
        if (Objects.equals(out, ceQuery.getOutput())) {
            return false;
        }
        OutputInconsistency outIncons = new OutputInconsistency(this.hypothesis.getInitialLocation(), new ContextPair(Word.epsilon(), ceWord), (Boolean)ceQuery.getOutput());
        do {
            this.splitState(outIncons);
            this.closeTransitions();
            while (this.finalizeAny()) {
                this.closeTransitions();
            }
        } while ((outIncons = this.findOutputInconsistency()) != null);
        return true;
    }

    protected boolean computeHypothesisOutput(Word<I> word) {
        State curr = this.hypothesis.getInitialState();
        for (Object sym : word) {
            curr = this.getAnySuccessor(curr, sym);
        }
        return this.hypothesis.isAccepting(curr);
    }

    private void splitState(OutputInconsistency<I> outIncons) {
        DTLearnerVPDA.PrefixTransformAcex acex = this.deriveAcex(outIncons);
        int breakpoint = this.analyzer.analyzeAbstractCounterexample((AbstractCounterexample)acex);
        Word acexSuffix = acex.getSuffix();
        Word prefix = acexSuffix.prefix(breakpoint);
        Object act = acexSuffix.getSymbol(breakpoint);
        Word suffix = acexSuffix.subWord(breakpoint + 1);
        State state = (State)this.hypothesis.getSuccessor((Object)acex.getBaseState(), (Iterable)prefix);
        State succState = (State)this.hypothesis.getSuccessor((Object)state, act);
        ContextPair context = new ContextPair(this.transformAccessSequence(succState.getStackContents()), suffix);
        AbstractHypTrans trans = this.hypothesis.getInternalTransition(state, act);
        HypLoc newLoc = this.makeTree(trans);
        DTNode oldDtNode = ((HypLoc)succState.getLocation()).getLeaf();
        this.openTransitions.addAll(oldDtNode.getIncoming());
        AbstractDTNode.SplitResult children = oldDtNode.split((Object)context, acex.effect(breakpoint), acex.effect(breakpoint + 1));
        oldDtNode.setTemp(true);
        if (!((DTNode)oldDtNode.getParent()).isTemp()) {
            this.blockList.add(oldDtNode);
        }
        TTTLearnerVPDA.link((DTNode)((DTNode)children.nodeOld), (HypLoc)newLoc);
        TTTLearnerVPDA.link((DTNode)((DTNode)children.nodeNew), (HypLoc)((HypLoc)succState.getLocation()));
        this.initializeLocation(newLoc);
    }

    protected boolean finalizeAny() {
        assert (this.openTransitions.isEmpty());
        GlobalSplitter<I> splitter = this.findSplitterGlobal();
        if (splitter != null) {
            this.finalizeDiscriminator(splitter.blockRoot, splitter.localSplitter);
            return true;
        }
        return false;
    }

    private OutputInconsistency<I> findOutputInconsistency() {
        OutputInconsistency best = null;
        for (HypLoc loc : this.hypothesis.getLocations()) {
            int locAsLen = loc.getAccessSequence().length();
            DTNode node = loc.getLeaf();
            while (!node.isRoot()) {
                boolean hypOut;
                boolean expectedOut = (Boolean)node.getParentOutcome();
                node = (DTNode)node.getParent();
                ContextPair discr = (ContextPair)node.getDiscriminator();
                if (best != null && discr.getLength() + locAsLen >= best.totalLength() || (hypOut = this.computeHypothesisOutput(discr.getPrefix().concat(new Word[]{loc.getAccessSequence(), discr.getSuffix()}))) == expectedOut) continue;
                best = new OutputInconsistency(loc, discr, expectedOut);
            }
        }
        return best;
    }

    protected State<HypLoc<I>> getAnySuccessor(State<HypLoc<I>> state, I sym) {
        VPDAlphabet.SymbolType type = this.alphabet.getSymbolType(sym);
        switch (type) {
            case INTERNAL: {
                AbstractHypTrans trans = this.hypothesis.getInternalTransition((HypLoc)state.getLocation(), sym);
                HypLoc succLoc = trans.isTree() ? trans.getTreeTarget() : (HypLoc)trans.getNonTreeTarget().subtreeLocsIterator().next();
                return new State((Object)succLoc, state.getStackContents());
            }
            case CALL: {
                int stackSym = this.hypothesis.encodeStackSym(state.getLocation(), sym);
                return new State((Object)this.hypothesis.getInitialLocation(), StackContents.push((int)stackSym, (StackContents)state.getStackContents()));
            }
            case RETURN: {
                AbstractHypTrans trans = this.hypothesis.getReturnTransition((HypLoc)state.getLocation(), sym, state.getStackContents().peek());
                HypLoc succLoc = trans.isTree() ? trans.getTreeTarget() : (HypLoc)trans.getNonTreeTarget().subtreeLocsIterator().next();
                return new State((Object)succLoc, state.getStackContents().pop());
            }
        }
        throw new IllegalStateException("Unhandled type " + type);
    }

    protected DTLearnerVPDA.PrefixTransformAcex deriveAcex(OutputInconsistency<I> outIncons) {
        DTLearnerVPDA.PrefixTransformAcex acex = new DTLearnerVPDA.PrefixTransformAcex((DTLearnerVPDA)this, outIncons.location.getAccessSequence(), outIncons.discriminator);
        acex.setEffect(0, (Object)outIncons.expectedOut);
        acex.setEffect(acex.getLength() - 1, (Object)(!outIncons.expectedOut ? 1 : 0));
        return acex;
    }

    private GlobalSplitter<I> findSplitterGlobal() {
        DTNode bestBlockRoot = null;
        Splitter<I> bestSplitter = null;
        for (DTNode blockRoot : this.blockList) {
            Splitter<I> splitter = this.findSplitter(blockRoot);
            if (splitter == null || bestSplitter != null && splitter.getNewDiscriminatorLength() >= bestSplitter.getNewDiscriminatorLength()) continue;
            bestSplitter = splitter;
            bestBlockRoot = blockRoot;
        }
        if (bestSplitter == null) {
            return null;
        }
        return new GlobalSplitter(bestBlockRoot, bestSplitter);
    }

    private void finalizeDiscriminator(DTNode<I> blockRoot, Splitter<I> splitter) {
        assert (blockRoot.isBlockRoot());
        ContextPair<I> newDiscr = splitter.getNewDiscriminator();
        if (!((ContextPair)blockRoot.getDiscriminator()).equals(newDiscr)) {
            ContextPair<I> finalDiscriminator = this.prepareSplit(blockRoot, splitter);
            HashMap<Boolean, DTNode<I>> repChildren = new HashMap<Boolean, DTNode<I>>();
            for (Boolean label : blockRoot.getSplitData().getLabels()) {
                repChildren.put(label, this.extractSubtree(blockRoot, label));
            }
            blockRoot.replaceChildren(repChildren);
            blockRoot.setDiscriminator(finalDiscriminator);
        } else {
            LOGGER.debug("Weird..");
        }
        this.declareFinal(blockRoot);
    }

    private Splitter<I> findSplitter(DTNode<I> blockRoot) {
        Object currLca;
        int i;
        int alphabetSize = this.alphabet.getNumInternals() + this.alphabet.getNumCalls() * this.alphabet.getNumReturns() * this.hypothesis.size() * 2;
        DTNode[] lcas = new DTNode[alphabetSize];
        for (HypLoc loc : blockRoot.subtreeLocations()) {
            i = 0;
            for (Object intSym : this.alphabet.getInternalSymbols()) {
                currLca = lcas[i];
                AbstractHypTrans trans = this.hypothesis.getInternalTransition(loc, intSym);
                assert (trans.getTargetNode() != null);
                lcas[i] = currLca == null ? trans.getTargetNode() : (DTNode)this.dtree.leastCommonAncestor((AbstractDTNode)currLca, (AbstractDTNode)trans.getTargetNode());
                ++i;
            }
            for (Object retSym : this.alphabet.getReturnSymbols()) {
                for (Object callSym : this.alphabet.getCallSymbols()) {
                    for (HypLoc stackLoc : this.hypothesis.getLocations()) {
                        AbstractHypTrans trans = this.hypothesis.getReturnTransition(loc, retSym, stackLoc, callSym);
                        DTNode currLca2 = lcas[i];
                        assert (trans.getTargetNode() != null);
                        lcas[i] = currLca2 == null ? trans.getTargetNode() : (DTNode)this.dtree.leastCommonAncestor((AbstractDTNode)currLca2, (AbstractDTNode)trans.getTargetNode());
                        trans = this.hypothesis.getReturnTransition(stackLoc, retSym, loc, callSym);
                        currLca2 = lcas[++i];
                        lcas[i] = currLca2 == null ? trans.getTargetNode() : (DTNode)this.dtree.leastCommonAncestor((AbstractDTNode)currLca2, (AbstractDTNode)trans.getTargetNode());
                        ++i;
                    }
                }
            }
        }
        int shortestLen = Integer.MAX_VALUE;
        Splitter shortestSplitter = null;
        i = 0;
        for (Object intSym : this.alphabet.getInternalSymbols()) {
            currLca = lcas[i];
            if (!currLca.isLeaf() && !currLca.isTemp()) {
                Splitter splitter = new Splitter(intSym, currLca);
                int newLen = splitter.getNewDiscriminatorLength();
                if (shortestSplitter == null || shortestLen > newLen) {
                    shortestSplitter = splitter;
                    shortestLen = newLen;
                }
            }
            ++i;
        }
        for (Object retSym : this.alphabet.getReturnSymbols()) {
            for (Object callSym : this.alphabet.getCallSymbols()) {
                for (HypLoc stackLoc : this.hypothesis.getLocations()) {
                    int newLen;
                    Splitter splitter;
                    DTNode currLca3 = lcas[i];
                    assert (currLca3 != null);
                    if (!currLca3.isLeaf() && !currLca3.isTemp()) {
                        splitter = new Splitter(retSym, stackLoc, callSym, false, currLca3);
                        newLen = splitter.getNewDiscriminatorLength();
                        if (shortestSplitter == null || shortestLen > newLen) {
                            shortestSplitter = splitter;
                            shortestLen = newLen;
                        }
                    }
                    currLca3 = lcas[++i];
                    assert (currLca3 != null);
                    if (!currLca3.isLeaf() && !currLca3.isTemp()) {
                        splitter = new Splitter(callSym, stackLoc, retSym, true, currLca3);
                        newLen = splitter.getNewDiscriminatorLength();
                        if (shortestSplitter == null || shortestLen > newLen) {
                            shortestSplitter = splitter;
                            shortestLen = newLen;
                        }
                    }
                    ++i;
                }
            }
        }
        return shortestSplitter;
    }

    private ContextPair<I> prepareSplit(DTNode<I> node, Splitter<I> splitter) {
        ContextPair<I> discriminator = splitter.getNewDiscriminator();
        ArrayDeque<Object> dfsStack = new ArrayDeque<Object>();
        DTNode succSeparator = splitter.succSeparator;
        dfsStack.push(node);
        assert (node.getSplitData() == null);
        while (!dfsStack.isEmpty()) {
            Boolean outcome;
            AbstractHypTrans<I> trans2;
            DTNode curr = (DTNode)dfsStack.pop();
            assert (curr.getSplitData() == null);
            curr.setSplitData(new SplitData(TransList::new));
            for (AbstractHypTrans<I> trans2 : curr.getIncoming()) {
                outcome = this.query((AccessSequenceProvider)trans2, discriminator);
                ((TransList)curr.getSplitData().getIncoming((Object)outcome)).add(trans2);
                TTTLearnerVPDA.markAndPropagate(curr, outcome);
            }
            if (curr.isInner()) {
                for (DTNode child : curr.getChildren()) {
                    dfsStack.push(child);
                }
                continue;
            }
            HypLoc loc = (HypLoc)curr.getData();
            assert (loc != null);
            trans2 = this.getSplitterTrans(loc, splitter);
            outcome = (Boolean)succSeparator.subtreeLabel((AbstractDTNode)trans2.getTargetNode());
            assert (outcome != null);
            curr.getSplitData().setStateLabel((Object)outcome);
            TTTLearnerVPDA.markAndPropagate(curr, outcome);
        }
        return discriminator;
    }

    private DTNode<I> extractSubtree(DTNode<I> root, Boolean label) {
        assert (root.getSplitData() != null);
        assert (root.getSplitData().isMarked((Object)label));
        ArrayDeque stack = new ArrayDeque();
        DTNode firstExtracted = new DTNode(root, label.booleanValue());
        stack.push(new ExtractRecord<I>(root, firstExtracted));
        while (!stack.isEmpty()) {
            ExtractRecord curr = (ExtractRecord)stack.pop();
            DTNode original = curr.original;
            DTNode extracted = curr.extracted;
            TTTLearnerVPDA.moveIncoming(extracted, original, label);
            if (original.isLeaf()) {
                if (Objects.equals(original.getSplitData().getStateLabel(), label)) {
                    TTTLearnerVPDA.link(extracted, (HypLoc)((HypLoc)original.getData()));
                } else {
                    this.createNewState(extracted);
                }
                extracted.updateIncoming();
            } else {
                ArrayList<DTNode> markedChildren = new ArrayList<DTNode>();
                for (DTNode child : original.getChildren()) {
                    if (!child.getSplitData().isMarked((Object)label)) continue;
                    markedChildren.add(child);
                }
                if (markedChildren.size() > 1) {
                    HashMap<Boolean, DTNode> childMap = new HashMap<Boolean, DTNode>();
                    for (DTNode c : markedChildren) {
                        Boolean childLabel = (Boolean)c.getParentOutcome();
                        DTNode extractedChild = new DTNode(extracted, childLabel.booleanValue());
                        childMap.put(childLabel, extractedChild);
                        stack.push(new ExtractRecord(c, extractedChild));
                    }
                    extracted.split((ContextPair)original.getDiscriminator(), childMap);
                    extracted.updateIncoming();
                    extracted.setTemp(true);
                } else if (markedChildren.size() == 1) {
                    stack.push(new ExtractRecord((DTNode)markedChildren.get(0), extracted));
                } else {
                    this.createNewState(extracted);
                    extracted.updateIncoming();
                }
            }
            assert (extracted.getSplitData() == null);
        }
        return firstExtracted;
    }

    protected void declareFinal(DTNode<I> blockRoot) {
        blockRoot.setTemp(false);
        blockRoot.setSplitData(null);
        blockRoot.removeFromBlockList();
        for (DTNode subtree : blockRoot.getChildren()) {
            assert (subtree.getSplitData() == null);
            if (!subtree.isInner()) continue;
            this.blockList.add(subtree);
        }
        this.openTransitions.addAll(blockRoot.getIncoming());
    }

    private static <I> void markAndPropagate(DTNode<I> node, Boolean label) {
        for (DTNode curr = node; curr != null && curr.getSplitData() != null; curr = (DTNode)curr.getParent()) {
            if (curr.getSplitData().mark((Object)label)) continue;
            return;
        }
    }

    public AbstractHypTrans<I> getSplitterTrans(HypLoc<I> loc, Splitter<I> splitter) {
        switch (splitter.type) {
            case INTERNAL: {
                return this.hypothesis.getInternalTransition(loc, splitter.symbol);
            }
            case RETURN: {
                return this.hypothesis.getReturnTransition(loc, splitter.symbol, splitter.location, splitter.otherSymbol);
            }
            case CALL: {
                return this.hypothesis.getReturnTransition(splitter.location, splitter.otherSymbol, loc, splitter.symbol);
            }
        }
        throw new IllegalStateException("Unhandled type " + (Object)((Object)splitter.type));
    }

    private static <I> void moveIncoming(DTNode<I> newNode, DTNode<I> oldNode, Boolean label) {
        newNode.getIncoming().addAll((TransList)oldNode.getSplitData().getIncoming((Object)label));
    }

    private void createNewState(DTNode<I> newNode) {
        LOGGER.debug("Create new state");
        AbstractHypTrans newTreeTrans = newNode.getIncoming().chooseMinimal();
        assert (newTreeTrans != null);
        HypLoc newLoc = this.makeTree(newTreeTrans);
        TTTLearnerVPDA.link(newNode, (HypLoc)newLoc);
        this.initializeLocation(newLoc);
    }

    protected void determinize(State<HypLoc<I>> state, Word<I> suffix) {
        State curr = state;
        for (Object sym : suffix) {
            AbstractHypTrans trans;
            if (!(this.alphabet.isCallSymbol(sym) || (trans = this.hypothesis.getInternalTransition(curr, sym)).isTree() || trans.getNonTreeTarget().isLeaf())) {
                this.updateDTTarget(trans, true);
            }
            curr = (State)this.hypothesis.getSuccessor((Object)curr, sym);
        }
    }
}

