/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.ttt.vpda;

import de.learnlib.algorithms.discriminationtree.hypothesis.vpda.ContextPair;
import de.learnlib.algorithms.discriminationtree.hypothesis.vpda.DTNode;
import de.learnlib.algorithms.discriminationtree.hypothesis.vpda.HypLoc;
import net.automatalib.words.Word;

public final class Splitter<I> {
    public final I symbol;
    public final HypLoc<I> location;
    public final I otherSymbol;
    public final SplitType type;
    public final DTNode<I> succSeparator;

    public Splitter(I symbol, DTNode<I> succSeparator) {
        this.symbol = symbol;
        this.location = null;
        this.otherSymbol = null;
        this.type = SplitType.INTERNAL;
        this.succSeparator = succSeparator;
    }

    public Splitter(I symbol, HypLoc<I> location, I otherSymbol, boolean call, DTNode<I> succSeparator) {
        this.symbol = symbol;
        this.location = location;
        this.otherSymbol = otherSymbol;
        this.type = call ? SplitType.CALL : SplitType.RETURN;
        this.succSeparator = succSeparator;
    }

    public ContextPair<I> getDiscriminator() {
        return (ContextPair)this.succSeparator.getDiscriminator();
    }

    public ContextPair<I> getNewDiscriminator() {
        Word prefix = ((ContextPair)this.succSeparator.getDiscriminator()).getPrefix();
        Word suffix = ((ContextPair)this.succSeparator.getDiscriminator()).getSuffix();
        switch (this.type) {
            case INTERNAL: {
                return new ContextPair(prefix, suffix.prepend(this.symbol));
            }
            case RETURN: {
                return new ContextPair(prefix.concat(new Word[]{this.location.getAccessSequence()}).append(this.otherSymbol), suffix.prepend(this.symbol));
            }
            case CALL: {
                return new ContextPair(prefix, this.location.getAccessSequence().prepend(this.symbol).append(this.otherSymbol).concat(new Word[]{suffix}));
            }
        }
        throw new IllegalStateException("Unhandled type " + (Object)((Object)this.type));
    }

    public int getNewDiscriminatorLength() {
        if (this.type == SplitType.INTERNAL) {
            return ((ContextPair)this.succSeparator.getDiscriminator()).getLength() + 1;
        }
        return ((ContextPair)this.succSeparator.getDiscriminator()).getLength() + this.location.getAccessSequence().length() + 2;
    }

    public static enum SplitType {
        INTERNAL,
        CALL,
        RETURN;

    }
}

