/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.examples.mealy;

import net.automatalib.automata.transout.MealyMachine;
import net.automatalib.automata.transout.MutableMealyMachine;
import net.automatalib.automata.transout.impl.compact.CompactMealy;
import net.automatalib.words.Alphabet;
import net.automatalib.words.impl.Alphabets;

public class ExampleStack {
    private static final Alphabet<Input> ALPHABET = Alphabets.fromEnum(Input.class);

    public static Alphabet<Input> getInputAlphabet() {
        return ALPHABET;
    }

    public static MealyMachine<?, Input, ?, Output> getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public static <S, A extends MutableMealyMachine<S, Input, ?, Output>> A constructMachine(A fm) {
        Object s0 = fm.addInitialState();
        Object s1 = fm.addState();
        Object s2 = fm.addState();
        Object s3 = fm.addState();
        fm.addTransition(s0, (Object)Input.PUSH, s1, (Object)Output.OK);
        fm.addTransition(s0, (Object)Input.POP, s0, (Object)Output.EMPTY);
        fm.addTransition(s1, (Object)Input.PUSH, s2, (Object)Output.OK);
        fm.addTransition(s1, (Object)Input.POP, s0, (Object)Output.OK);
        fm.addTransition(s2, (Object)Input.PUSH, s3, (Object)Output.OK);
        fm.addTransition(s2, (Object)Input.POP, s1, (Object)Output.OK);
        fm.addTransition(s3, (Object)Input.PUSH, s3, (Object)Output.FULL);
        fm.addTransition(s3, (Object)Input.POP, s2, (Object)Output.OK);
        return fm;
    }

    public static CompactMealy<Input, Output> constructMachine() {
        return ExampleStack.constructMachine(new CompactMealy(ALPHABET));
    }

    public static enum Output {
        OK,
        EMPTY,
        FULL;

    }

    public static enum Input {
        PUSH,
        POP;

    }

    private static final class InstanceHolder {
        public static final MealyMachine<?, Input, ?, Output> INSTANCE = ExampleStack.constructMachine();

        private InstanceHolder() {
        }
    }
}

