/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.examples.dfa;

import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.fsa.MutableDFA;
import net.automatalib.automata.fsa.impl.compact.CompactDFA;
import net.automatalib.words.Alphabet;
import net.automatalib.words.impl.Alphabets;

public class ExampleAngluin {
    private static final Alphabet<Integer> ALPHABET = Alphabets.integers((int)0, (int)1);

    public static Alphabet<Integer> getInputAlphabet() {
        return ALPHABET;
    }

    public static DFA<?, Integer> getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public static <A extends MutableDFA<S, ? super Integer>, S> A constructMachine(A machine) {
        Object q0 = machine.addInitialState(true);
        Object q1 = machine.addState(false);
        Object q2 = machine.addState(false);
        Object q3 = machine.addState(false);
        machine.addTransition(q0, (Object)0, q1);
        machine.addTransition(q0, (Object)1, q2);
        machine.addTransition(q1, (Object)0, q0);
        machine.addTransition(q1, (Object)1, q3);
        machine.addTransition(q2, (Object)0, q3);
        machine.addTransition(q2, (Object)1, q0);
        machine.addTransition(q3, (Object)0, q2);
        machine.addTransition(q3, (Object)1, q1);
        return machine;
    }

    public static CompactDFA<Integer> constructMachine() {
        return ExampleAngluin.constructMachine(new CompactDFA(ALPHABET));
    }

    private static final class InstanceHolder {
        public static final DFA<?, Integer> INSTANCE = ExampleAngluin.constructMachine();

        private InstanceHolder() {
        }
    }
}

