/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.statistic.oracle;

import de.learnlib.filter.statistic.HistogramDataSet;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.Query;
import de.learnlib.statistic.StatisticOracle;
import java.util.Collection;

public class HistogramOracle<I, D>
implements StatisticOracle<I, D> {
    private final HistogramDataSet dataSet;
    private final MembershipOracle<I, D> delegate;

    public HistogramOracle(MembershipOracle<I, D> next, String name) {
        this.delegate = next;
        this.dataSet = new HistogramDataSet(name, "query length");
    }

    public final void processQueries(Collection<? extends Query<I, D>> queries) {
        for (Query<I, D> q : queries) {
            this.dataSet.addDataPoint((long)q.getPrefix().size() + (long)q.getSuffix().size());
        }
        this.delegate.processQueries(queries);
    }

    public final HistogramDataSet getStatisticalData() {
        return this.dataSet;
    }
}

