/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.statistic.oracle;

import de.learnlib.filter.statistic.Counter;
import de.learnlib.filter.statistic.CounterCollection;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.Query;
import de.learnlib.statistic.StatisticData;
import de.learnlib.statistic.StatisticOracle;
import java.util.Arrays;
import java.util.Collection;

public class CounterOracle<I, D>
implements StatisticOracle<I, D> {
    private final MembershipOracle<I, D> delegate;
    private final Counter queryCounter;
    private final Counter symbolCounter;

    public CounterOracle(MembershipOracle<I, D> delegate) {
        this.delegate = delegate;
        this.queryCounter = new Counter("Queries", "#");
        this.symbolCounter = new Counter("Symbols", "#");
    }

    public void processQueries(Collection<? extends Query<I, D>> queries) {
        this.queryCounter.increment(queries.size());
        for (Query<I, D> qry : queries) {
            this.symbolCounter.increment(qry.getPrefix().length() + qry.getSuffix().length());
        }
        this.delegate.processQueries(queries);
    }

    public Counter getQueryCounter() {
        return this.queryCounter;
    }

    public Counter getSymbolCounter() {
        return this.symbolCounter;
    }

    public StatisticData getStatisticalData() {
        return new CounterCollection(Arrays.asList(this.queryCounter, this.symbolCounter));
    }
}

