/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.statistic;

import de.learnlib.filter.statistic.AbstractStatisticData;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class HistogramDataSet
extends AbstractStatisticData {
    private final SortedMap<Long, Integer> histogram = new TreeMap<Long, Integer>();
    private long size;
    private long sum;
    private double mean;

    public HistogramDataSet(String name, String unit) {
        super(name, unit);
    }

    public void addDataPoint(Long value) {
        Integer i = (Integer)this.histogram.get(value);
        if (i == null) {
            i = 0;
        }
        this.histogram.put(value, i + 1);
        this.sum += value.longValue();
        ++this.size;
        this.mean += ((double)value.longValue() - this.mean) / (double)this.size;
    }

    public SortedMap<Long, Integer> getHistogram() {
        return this.histogram;
    }

    public double getMean() {
        return this.mean;
    }

    public long getSize() {
        return this.size;
    }

    public long getSum() {
        return this.sum;
    }

    public double getMedian() {
        long idx = 0L;
        for (Map.Entry<Long, Integer> e : this.histogram.entrySet()) {
            int count = e.getValue();
            if ((idx += (long)count) < this.size / 2L) continue;
            return e.getKey().longValue();
        }
        return 0.0;
    }

    public String getSummary() {
        return this.getName() + " [" + this.getUnit() + "]: " + this.size + " (count), " + this.sum + " (sum), " + this.mean + " (mean), " + this.getMedian() + " (median)";
    }

    public String getDetails() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getSummary()).append(System.lineSeparator());
        for (Map.Entry<Long, Integer> e : this.histogram.entrySet()) {
            sb.append('\t').append(e.getKey()).append(", ").append(e.getValue()).append(System.lineSeparator());
        }
        return sb.toString();
    }
}

