/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.statistic.oracle;

import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.api.query.Query;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;

public class JointCounterOracle<I, D>
implements MembershipOracle<I, D> {
    private final MembershipOracle<I, D> delegate;
    private final AtomicLong queryCounter = new AtomicLong();
    private final AtomicLong symbolCounter = new AtomicLong();

    public JointCounterOracle(MembershipOracle<I, D> delegate) {
        this.delegate = delegate;
    }

    public void processQueries(Collection<? extends Query<I, D>> queries) {
        this.queryCounter.addAndGet(queries.size());
        for (Query<I, D> qry : queries) {
            this.symbolCounter.addAndGet(qry.getInput().length());
        }
        this.delegate.processQueries(queries);
    }

    public long getQueryCount() {
        return this.queryCounter.get();
    }

    public long getSymbolCount() {
        return this.symbolCounter.get();
    }
}

