/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.statistic.learner;

import de.learnlib.api.algorithm.LearningAlgorithm;
import de.learnlib.api.query.DefaultQuery;
import de.learnlib.api.statistic.StatisticLearner;
import de.learnlib.filter.statistic.Counter;

public class RefinementCounterLearner<M, I, D>
implements StatisticLearner<M, I, D> {
    private final LearningAlgorithm<M, I, D> learningAlgorithm;
    private final Counter counter;

    public RefinementCounterLearner(String name, LearningAlgorithm<M, I, D> learningAlgorithm) {
        this.counter = new Counter(name, "refinements");
        this.learningAlgorithm = learningAlgorithm;
    }

    public void startLearning() {
        this.learningAlgorithm.startLearning();
    }

    public boolean refineHypothesis(DefaultQuery<I, D> ceQuery) {
        boolean refined = this.learningAlgorithm.refineHypothesis(ceQuery);
        if (refined) {
            this.counter.increment();
        }
        return refined;
    }

    public M getHypothesisModel() {
        return (M)this.learningAlgorithm.getHypothesisModel();
    }

    public Counter getStatisticalData() {
        return this.counter;
    }
}

