/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.statistic.sul;

import de.learnlib.api.SUL;
import de.learnlib.api.exception.SULException;
import de.learnlib.api.statistic.StatisticSUL;
import de.learnlib.filter.statistic.Counter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SymbolCounterSUL<I, O>
implements StatisticSUL<I, O> {
    private final SUL<I, O> sul;
    private final Counter counter;

    public SymbolCounterSUL(String name, SUL<I, O> sul) {
        this(new Counter(name, "symbols"), sul);
    }

    protected SymbolCounterSUL(Counter counter, SUL<I, O> sul) {
        this.counter = counter;
        this.sul = sul;
    }

    public void pre() {
        this.sul.pre();
    }

    public void post() {
        this.sul.post();
    }

    @Nullable
    public O step(@Nullable I in) throws SULException {
        this.counter.increment();
        return (O)this.sul.step(in);
    }

    public boolean canFork() {
        return this.sul.canFork();
    }

    public SUL<I, O> fork() {
        return new SymbolCounterSUL<I, O>(this.counter, this.sul.fork());
    }

    @Nonnull
    public Counter getStatisticalData() {
        return this.counter;
    }

    public boolean equals(Object obj) {
        return this.sul.equals(obj);
    }

    public int hashCode() {
        return this.sul.hashCode();
    }

    public String toString() {
        return this.sul.toString();
    }
}

