/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.statistic.learner;

import de.learnlib.api.algorithm.LearningAlgorithm;
import de.learnlib.api.query.DefaultQuery;
import de.learnlib.api.statistic.StatisticLearner;
import de.learnlib.filter.statistic.Counter;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.transducers.MealyMachine;
import net.automatalib.words.Word;

@ParametersAreNonnullByDefault
public class RefinementCounterLearner<M, I, D>
implements StatisticLearner<M, I, D> {
    private final LearningAlgorithm<M, I, D> learningAlgorithm;
    private final Counter counter;

    public RefinementCounterLearner(String name, LearningAlgorithm<M, I, D> learningAlgorithm) {
        this.counter = new Counter(name, "refinements");
        this.learningAlgorithm = learningAlgorithm;
    }

    public void startLearning() {
        this.learningAlgorithm.startLearning();
    }

    public boolean refineHypothesis(@Nonnull DefaultQuery<I, D> ceQuery) {
        boolean refined = this.learningAlgorithm.refineHypothesis(ceQuery);
        if (refined) {
            this.counter.increment();
        }
        return refined;
    }

    @Nonnull
    public M getHypothesisModel() {
        return (M)this.learningAlgorithm.getHypothesisModel();
    }

    @Nonnull
    public Counter getStatisticalData() {
        return this.counter;
    }

    public static class MealyRefinementCounterLearner<I, O>
    extends RefinementCounterLearner<MealyMachine<?, I, ?, O>, I, Word<O>>
    implements StatisticLearner.MealyStatisticLearner<I, O> {
        public MealyRefinementCounterLearner(String name, LearningAlgorithm<MealyMachine<?, I, ?, O>, I, Word<O>> learningAlgorithm) {
            super(name, learningAlgorithm);
        }
    }

    public static class DFARefinementCounterLearner<I>
    extends RefinementCounterLearner<DFA<?, I>, I, Boolean>
    implements StatisticLearner.DFAStatisticLearner<I> {
        public DFARefinementCounterLearner(String name, LearningAlgorithm<DFA<?, I>, I, Boolean> learningAlgorithm) {
            super(name, learningAlgorithm);
        }
    }
}

