/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.statistic.oracle;

import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.api.query.Query;
import de.learnlib.api.statistic.StatisticOracle;
import de.learnlib.filter.statistic.Counter;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.words.Word;

@ParametersAreNonnullByDefault
public class CounterOracle<I, D>
implements StatisticOracle<I, D> {
    private final Counter counter;
    private MembershipOracle<I, D> nextOracle;

    public CounterOracle(MembershipOracle<I, D> nextOracle, String name) {
        this.nextOracle = nextOracle;
        this.counter = new Counter(name, "queries");
    }

    public void processQueries(Collection<? extends Query<I, D>> queries) {
        this.counter.increment(queries.size());
        this.nextOracle.processQueries(queries);
    }

    @Nonnull
    public Counter getStatisticalData() {
        return this.counter;
    }

    @Nonnull
    public Counter getCounter() {
        return this.counter;
    }

    public long getCount() {
        return this.counter.getCount();
    }

    public void setNext(MembershipOracle<I, D> next) {
        this.nextOracle = next;
    }

    public static class MealyCounterOracle<I, O>
    extends CounterOracle<I, Word<O>>
    implements MembershipOracle.MealyMembershipOracle<I, O> {
        public MealyCounterOracle(MembershipOracle<I, Word<O>> nextOracle, String name) {
            super(nextOracle, name);
        }
    }

    public static class DFACounterOracle<I>
    extends CounterOracle<I, Boolean>
    implements MembershipOracle.DFAMembershipOracle<I> {
        public DFACounterOracle(MembershipOracle<I, Boolean> nextOracle, String name) {
            super(nextOracle, name);
        }
    }
}

